module Main where

import Point
import Control.Exception
import System.CPUTime

import Accept
import KDtree
import PointSort

main = readIntPts [] >>= \pts -> let tour = if accept pts
                                            then frp pts
                                            else error "\nErro FRP.013 -> O Caixeiro Viajante nao consegue entender o mapa (input invalido)"
                                 in putStr (showPoints (tour))

--------------------------------------------------------------------------------
-- Funcao para contruir a KDtree (LazyKDtree, ate 10 pontos numa folha)

data LazyKDtree a =
   LazyLeafKD [(Point a)]
 | LazyNode2KD (LazyKDtree a) a Bool (LazyKDtree a)
 deriving (Eq, Read, Show)

lazyBuildY [] = error "\nErro FRP.024 -> O Caixeiro Viajante caiu da arvore"

lazyBuildY ps = if (length ps) <= 10
                then LazyLeafKD ps
                else case (partitionY (sortY ps)) of
                     AllEqual -> lazyBuildX ps
                     FirstEqual(b, c, key) ->
                        (LazyNode2KD (lazyBuildX b) key False (lazyBuildX c))
                     LastEqual(a, b, key) ->
                        (LazyNode2KD (lazyBuildX a) (key - 1) False (lazyBuildX b))
                     PartitionOk(a, b, c, key) ->
                        (LazyNode2KD (lazyBuildX (a ++ b)) key False (lazyBuildX c))

lazyBuildX [] = error "\nErro FRP.037 -> O Caixeiro Viajante caiu da arvore"

lazyBuildX ps = if (length ps) <= 10
                then LazyLeafKD ps
                else case (partitionX (sortX ps)) of
                     AllEqual -> lazyBuildY ps
                     FirstEqual(b, c, key) ->
                        (LazyNode2KD (lazyBuildY b) key True (lazyBuildY c))
                     LastEqual(a, b, key) ->
                        (LazyNode2KD (lazyBuildY a) (key - 1) True (lazyBuildY b))
                     PartitionOk(a, b, c, key) ->
                        (LazyNode2KD (lazyBuildY (a ++ b)) key True (lazyBuildY c))

lazyBuild ps = lazyBuildX ps

--------------------------------------------------------------------------------
-- Implementacao da heuristica NN

nnAux p _ 1 = [p]

nnAux p tree lim = p:(nnAux np (delete p tree) (lim - 1))
                   where np = nearSearch p tree

nn [] = error "\nErro FRP.060 -> O Caixeiro Viajante nao tem para onde ir"

nn [x] = [x]

nn [x, y] = [x, y]

nn [x, y, z] = [x, y, z]

nn (p:ps) = p:(nnAux np (delete np tree) (length ps))
            where tree = build ps
                  np = nearSearch p tree

--------------------------------------------------------------------------------
-- Procura o ponto extremo (direito, esquerdo, inferior ou superior) de um tour

minX (a, b) (c, d) =
   if a <= c then (a, b) else (c, d)

leftX [] = error "\nErro FRP.078 -> O Caixeiro Viajante foi para o lugar errado"

leftX [p] = p

leftX (p:ps) = minX p (leftX ps)

---

maxX (a, b) (c, d) =
   if a >= c then (a, b) else (c, d)

rightX [] = error "\nErro FRP.089 -> O Caixeiro Viajante foi para o lugar errado"

rightX [p] = p

rightX (p:ps) = maxX p (rightX ps)

---

minY (a, b) (c, d) =
   if b <= d then (a, b) else (c, d)

bottomY [] = error "\nErro FRP.100 -> O Caixeiro Viajante foi para o lugar errado"

bottomY [p] = p

bottomY (p:ps) = minY p (bottomY ps)

---

maxY (a, b) (c, d) =
   if b >= d then (a, b) else (c, d)

topY [] = error "\nErro FRP.111 -> O Caixeiro Viajante foi para o lugar errado"

topY [p] = p

topY (p:ps) = maxY p (topY ps)

--------------------------------------------------------------------------------
-- Divide um tour

splitTour key [] = ([], [])

splitTour key (p:ps) =
   if p /= key then (p:a, b) else ([], ps)
   where (a, b) = splitTour key ps

--------------------------------------------------------------------------------
-- Faz o merge de dois tours

-- left -> <- right
mergeLR leftTour rightTour =
   b ++ a ++ [key1, key2] ++ d ++ c
   where key1 = rightX leftTour
         key2 = leftX rightTour
         (a, b) = splitTour key1 leftTour
         (c, d) = splitTour key2 rightTour

-- bottom -> <- top
mergeBT bottomTour topTour =
   b ++ a ++ [key1, key2] ++ d ++ c
   where key1 = topY bottomTour
         key2 = bottomY topTour
         (a, b) = splitTour key1 bottomTour
         (c, d) = splitTour key2 topTour

--------------------------------------------------------------------------------
-- Constroi um tour a partitr de uma KDtree

tree = LazyLeafKD [(1551,496),(1614,496),(1913,630),(1551,654),(1614,654)]

frpAux (LazyLeafKD ps) = nn ps

frpAux (LazyNode2KD left _ cut right) =
   if cut
   then mergeLR (frpAux left) (frpAux right)
   else mergeBT (frpAux left) (frpAux right)

frp [] = error "\nErro FRP.157 -> O Caixeiro Viajante nao tem para onde ir"

frp [x] = [x]

frp [x, y] = [x, y]

frp [x, y, z] = [x, y, z]

frp ps = frpAux (lazyBuild ps)
