module Pqgreedy where

import List
import Point
import KDTree
import System.IO
import Control.Exception


type Pointg a  = (Point a,Point a)
type PointGr a = ((Point a),Int)

data (Ord a, Read a, Show a, (Show (Int,[PointGr a]))) =>
  Condition a = 
	  IgnoreEdge
	| FindNewN
	| InsertEdge (Int,[PointGr a]) (Int,[PointGr a])
	deriving (Eq,Read,Show)

data Binpqgreedy a =
	Nill
	|Nodepq (a, Point a, Point a) (Binpqgreedy a) (Binpqgreedy a)
	deriving Show

-------------------------PQGREEDY---------------------------------------------------------------

pqgreedy	::	(Ord a, Num a, Read a) =>
				[Point a] -> [Point a]
doit		::	(Ord a, Num a, Read a) =>
				Binpqgreedy a -> KDtree a -> [[PointGr a]] -> [Point a] -> [Point a] -> [[PointGr a]]
update		::	(Int, [PointGr a]) -> Point a -> (Int, [PointGr a]) -> Point a -> [Point a] -> [Point a] -> ([Point a],[Point a])
insertionP	::	(Ord a, Num a, Read a) =>
				Point a -> Point a -> Binpqgreedy a -> KDtree a -> [[PointGr a]] -> [Point a] -> [Point a] -> [[PointGr a]]
reSearch	::	(Ord a, Num a, Read a) =>
				Point a -> Binpqgreedy a -> KDtree a -> [[PointGr a]] -> [Point a] -> [Point a] -> [[PointGr a]]
whatToDo	::	(Ord a, Num a, Read a) =>
				Point a -> Point a -> [[PointGr a]] -> [Point a] -> [Point a] -> Condition a
degree		::	Eq a => Point a -> [[PointGr a]] -> [Point a] -> [Point a] -> (Int, [PointGr a])

testHead	::	Eq a => Point a -> [PointGr a] -> Point a -> [[PointGr a]] -> [[PointGr a]]
mergesubTour	::	Eq a => Point a -> [PointGr a] -> Point a -> [PointGr a] -> [[PointGr a]] -> [[PointGr a]]
isHead		::	Eq a => Point a -> [PointGr a] -> Bool
insertEdge	::	Num a =>
			Point a -> (Int,[PointGr a]) -> Point a -> (Int,[PointGr a]) -> [[PointGr a]] -> [[PointGr a]]
filterDegree	::	[[PointGr a]] -> [Point a]

merge		::	Ord a => Binpqgreedy a -> Binpqgreedy a -> Binpqgreedy a
insertbinpq	::	Ord a => Binpqgreedy a -> (a, Point a, Point a) -> Binpqgreedy a
findMin		::	Ord a => Binpqgreedy a -> (a, Point a, Point a)
delmin		::	Ord a => Binpqgreedy a -> Binpqgreedy a
pop		::	Ord a => Binpqgreedy a -> ((a, Point a, Point a), Binpqgreedy a)

-------------------------------------------------------------------------------------------------

pqgreedy [ ]	=	[ ]
pqgreedy [p]	=	[p]
pqgreedy xs	=
  let
	tree	=	KDTree.build xs
	nnp a	=	KDTree.nn2 a tree
	binpq	=	buildBinpq xs Nill tree
	tour	=	doit binpq tree [] [] []
  in
	filterDegree tour

buildBinpq [ ] btree ktree	=	btree
buildBinpq (w:ws) btree ktree	=
  let	
	np		=	KDTree.nn2 w ktree
	btree2	(d,n)	=	insertbinpq btree (d,w,n)
  in	
  case ( np ) of
	EmptyTree	->	btree
	EmptyLeaf	->	btree
	NNPoint (a,b)	->	buildBinpq ws (btree2 (a,b)) ktree

filterDegree xs		=	[ a | ys<-xs, (a,g)<- ys ]

doit binpq tree [] [] []=
  let	((d,c,n),binpq2)	=	pop binpq
  in	doit binpq2 tree [[(c,1),(n,1)]] [c,n] []

doit Nill _ tour _ _		=	tour

doit binpq tree tour one two	=
  let
	((d,c,n),binpq2)	=	pop binpq
	ntour a b		=	insertEdge c a n b tour
	updt a b		=	update a c b n one two
  in
  case ( whatToDo c n tour one two ) of
	IgnoreEdge		->	doit binpq2 tree tour one two
	FindNewN		->	insertionP c n binpq2 tree tour one two
	InsertEdge pC pN	->	doit binpq2 tree (ntour pC pN) (fst (updt pC pN)) (snd (updt pC pN))

update (dA,sA) a (dB,sB) b one two
	| dA==1 && dB==1	=	( one, [a,b]++two )
	| dA==1			=	( (b:one), (a:two) )
	| dB==1			=	( (a:one), (b:two) )
	| otherwise		=	( [a,b]++one, two )

insertionP c n binpq tree tour one two =
  let
	tree2		=	KDTree.delete n tree
	nnk		=	KDTree.nn2 c tree2
  in
  case ( nnk ) of
	EmptyTree	->	tour
	EmptyLeaf	->	reSearch c binpq tree2 tour one two
	NNPoint (d2,n2)	->	doit (insertbinpq binpq (d2,c,n2)) tree2 tour one two

reSearch c binpq tree tour one two	=
  let
	tree2		=	KDTree.rebuild tree
	nnk		=	KDTree.nn2 c tree2
  in
  case ( nnk ) of
	EmptyTree	->	tour
	EmptyLeaf	->	tour
	NNPoint (d2,n2)	->	doit (insertbinpq binpq (d2,c,n2)) tree2 tour one two

whatToDo c n tour one two
	| gC == 2		=	IgnoreEdge
	| gN == 2		=	FindNewN
	| gC == 1 && subC==subN =	FindNewN
	| otherwise		=	InsertEdge (gC,subC) (gN,subN)
  where	(gC,subC)		=	degree c tour one two
	(gN,subN)		=	degree n tour one two

degree p _ [ ] [ ]		=	(0,[])
degree p tour one two
	| elem p two		=	(2,( sub2 p tour ))
	| elem p one		=	(1,( sub1 p tour ))
	| otherwise		=	(0,[])

sub1 p (w:ws)
	| (p,1)==head w || (p,1)==last w	=	w
	| otherwise				=	sub1 p ws

sub2 p (w:ws)
	| elem (p,2) w				=	w
	| otherwise				=	sub2 p ws


insertEdge c (gC,subC) n (gN,subN) tour
	| gC==0 && gN==0	=	[(c,1),(n,1)]:tour
	| gC==1 && gN==0	=	testHead c subC n tour
	| gC==0 && gN==1	=	testHead n subN c tour
	| otherwise		=	mergesubTour c subC n subN tour

testHead a subA b tour
	| isHead a subA		=	( [(b,1),(a,2)]++(tail subA) ) : subTour
	| otherwise		=	( (init subA)++[(a,2),(b,1)] ) : subTour
  where	subTour			=	List.delete subA tour

mergesubTour a subA b subB tour
	| headA && headB	=	((reverse (tail subA))++[(a,2),(b,2)]++(tail subB)):(subTour)
	| headA			=	((init subB)++[(b,2),(a,2)]++(tail subA)):(subTour)
	| headB			=	((init subA)++[(a,2),(b,2)]++(tail subB)):(subTour)
	| otherwise		=	((init subA)++[(a,2),(b,2)]++(reverse (init subB))):(subTour)
  where	subTour			=	(List.delete subA (List.delete subB tour))
	(headA, headB)		=	(isHead a subA, isHead b subB)

isHead z [ ]		=	False
isHead z ((x,_):xs)	=	z == x

istour (a:rray) = 
	if ( elem a rray )
	then ( False )
	else ( istour rray )

----------------------BINPQ PQGREEDY--------------------------------------

---------------------------------------------------------------------
merge Nill Nill	=	Nill
merge Nill ys	=	ys
merge xs Nill	=	xs
merge t1@(Nodepq a@(d1,c1,n1) xs ys) t2@(Nodepq b@(d2,c2,n2) us vs)
	| d1 < d2	=	Nodepq a (merge ys t2) xs
	| otherwise	=	Nodepq b (merge t1 vs) us


insertbinpq Nill a			=	Nodepq a Nill Nill
insertbinpq t0@(Nodepq a xs ys) b	=	merge t0 (Nodepq b Nill Nill)


findMin (Nodepq a xs ys)	=	a

delmin Nill			=	Nill
delmin  (Nodepq a xs ys)	=	merge xs ys

pop binpq			=	(findMin binpq, delmin binpq)

