
-- TRABALHO 0, EXERCICIO 4

module Binpq where

import Point

data Binpq a =
	Null
	|Node (Point a) (Binpq a) (Binpq a)
	deriving Show

------------------------BINPQ----------------------------------------

merge   :: Ord a => Binpq a -> Binpq a -> Binpq a
insert  :: Ord a => Binpq a -> Point a -> Binpq a
findMin :: Ord a => Binpq a -> Point a
delmin  :: Ord a => Binpq a -> Binpq a

---------------------------------------------------------------------
merge Null Null	=	Null
merge Null ys	=	ys
merge xs Null	=	xs
merge t1@(Node a xs ys) t2@(Node b us vs)
	|a < b		=	Node a (merge ys t2) xs
	|otherwise	=	Node b (merge t1 vs) us

insert Null a			=	Node a Null Null
insert t0@(Node a xs ys) b	=	merge t0 (Node b Null Null)

findMin (Node a xs ys)	=	a
delmin  (Node a xs ys)	=	merge xs ys


------------------------ISBINPQ-------------------------------------------

isbinpq :: Ord a => Binpq a -> Bool

isbinpq Null			=	True
isbinpq (Node a Null Null)	=	True
isbinpq (Node a xs ys)	=	(lesser a xs) && (lesser a ys)

lesser a (Node b xs ys)
	|a < b			=	isbinpq (Node b xs ys)
	|otherwise		=	False
