module Point where

-- import module 'System.IO' that defines IO functions
import System.IO

-- the type 'Point a' is defined as a pair of coordinates
type Point a = (a,a)

-- 'readpoints' maps a list of 'String' to an 'IO' list of 'Point a'
--  'a' is restricted by '(Read a)' to be readable

readPoints :: (Read a) => [String] -> IO [Point a]


readPoints xs = isEOF >>= \eof -> if eof
                                  then return (map read (reverse xs))
                                  else getLine >>= \ln -> readPoints (ln:xs)

-- 'readIntPts' is a specific instance of 'readPoints' to read points with
--              Int coordinates
readIntPts :: [String] -> IO [Point Int]
readIntPts = readPoints

showPoints :: (Show a) => [Point a] -> String

showPoints pts = unlines (map show pts)
