
-- TRABALHO 0, EXERCICIO 1

module KDTree where

import Point

type Pointk a = (Point a,Bool)
type PointDist a = (a,Point a,Point a)
type Pointnnk a = (a,Bool,Bool)

data KDtree a =
	Null
	|Leaf [Pointk a]
	|Node Bool a (KDtree a) (KDtree a)
	deriving Show

-----------------------------------KDTREE------------------------------------------------------

build    :: (Ord a, Num a) => [Point a] -> KDtree a
makeTree :: Ord a => [Point a] -> Bool -> KDtree a
makeNode :: Ord a => [Point a] -> Bool -> KDtree a

-----------------------------------------------------------------------------------------------

build [] 	=	Null
build ws 	=	makeTree ws (xory ws)

xory ws	=
  let	(x,y)	=	unzip ws
  in			( sum x >= sum y )

makeTree ws coord = 
	if 	( length ws <= 8 )
	then 	( Leaf [ (p,True) | p<-ws ] )
	else	if 	( coord )
		then	( makeNode (qsortx ws) coord )
		else	( makeNode (qsorty ws) coord )

makeNode ws coord =
  let
	(x,y)		=	ws!!mid
	mid		=	( div (length ws) 2 ) - 1
	(sure,unsure)	=	( take mid ws, drop mid ws )
	(leftx, rightx)	=	( sure++(takeWhile (<=(x,y)) unsure), (dropWhile (<=(x,y)) unsure) )
	(lefty, righty)	=	( sure++(takewhile y unsure), (dropwhile y unsure) )
  in
	if	( coord )
	then	( Node coord x
		( makeTree leftx  (not coord) )
		( makeTree rightx (not coord) ) )
	else	( Node coord y
		( makeTree lefty  (not coord) )
		( makeTree righty (not coord) ) )

takewhile a [] = []
takewhile a ((x,y):ws) 
	| y <= a	=	(x,y):(takewhile a ws)
	| otherwise	=	[]

dropwhile a [] = []
dropwhile a ((x,y):ws) 
	| y <= a	=	(dropwhile a ws)
	| otherwise	=	(x,y):ws


-----ISKDTREE--------------------------------------------------------

type Part a = (a, Bool, Bool)
-- tipo -> (valor de partiocionamente, coordenada de particionamento, lado da arvore)

isKDtree :: Ord a => KDtree a -> Bool
testNode :: Ord a => [Part a] -> KDtree a -> Bool
testLeaf :: Ord a => Part a -> Pointk a -> Bool

----------------------------------------------------------------------------------
isKDtree (Leaf ws)		=	( length ws <= 8 )
isKDtree (Node coord b us vs)	=	
	   ( testNode [(b, coord, False)] us )
	&& ( testNode [(b, coord, True )] vs )

testNode _ Null		=	True
testNode parts (Node coord b us vs)	=
	    ( testNode ( ( b, coord, False ):parts ) us )
	 && ( testNode ( ( b, coord, True  ):parts ) vs )

testNode parts (Leaf ws)	=	(and ( [ testLeaf p w | p<-parts, w<-ws ] )) && ( length ws <= 8 )

testLeaf (p,coord,wing) ((x,y),del) =
	if	( coord )
	then	if ( wing ) then ( x>p ) else ( x<=p )
	else	if ( wing ) then ( y>p ) else ( y<=p )


--------------------------------------NN-------------------------------------------------------------

data (Ord a, Read a, Show a, (Show (a, Point a))) =>
  NNCondition a =
	  EmptyTree
	| EmptyLeaf
	| NNPoint (a, Point a)
	deriving (Eq,Read,Show)



nn		::	(Num a, Ord a, Read a) =>
			(Point a) -> (KDtree a) -> (Point a)
nn2		::	(Num a, Ord a, Read a) =>
			(Point a) -> (KDtree a) -> NNCondition a
pathfinder	::	(Num a, Ord a, Read a) =>
			[Pointnnk a] -> Point a -> KDtree a -> KDtree a -> NNCondition a
parttest	::	(Num a, Ord a, Read a) =>
			Pointnnk a -> Point a -> a -> Bool
findother	::	(Num a, Ord a, Read a) =>
			KDtree a -> Point a -> [Pointnnk a] -> [Bool] -> (a,Point a) -> NNCondition a
compnn		::	(Ord a, Read a, Show a) =>
			(a, Point a) -> NNCondition a -> NNCondition a
comp		::	Ord a => (a, Point a) -> (a, Point a) -> (a, Point a)
getLeafs	::	KDtree a -> [Pointk a]
rebuild		::	(Num a, Ord a) => KDtree a -> KDtree a
distance	::	Num a => Point a -> Point a -> a

------------------------------------------------------------------------------------------------------

rebuild Null		=	Null
rebuild (Leaf ws)	=	build ([ w | (w,bool)<-ws, bool ])
rebuild tree		=	build treelist
  where	leafs		=	getLeafs tree
	treelist	=	[ point | (point,bool)<-leafs, bool ]


nn p tree	=
  case ( nn2 p tree ) of
	EmptyTree	->	error ("The tree is empty")
	EmptyLeaf	->	nn p (rebuild tree)
	NNPoint nnp	->	snd nnp

nn2 p Null		=	EmptyTree
nn2 p (Leaf ws)
	| array==[]	=	EmptyLeaf
	| otherwise	=	NNPoint ( minimum array )
  where	array		=	[ ((distance p w),w) | (w,bool)<-ws, bool, (p/=w) ]
nn2 p tree		=	pathfinder [] p tree tree

pathfinder path point (Node bool a us vs) tree =
	if	( bool )
	then
		if	( (fst point) > a )
		then	( pathfinder (path++[(a,True,True)])  point vs tree )
		else	( pathfinder (path++[(a,True,False)]) point us tree )
	else
		if	( (snd point) > a )
		then	( pathfinder (path++[(a,False,True)])  point vs tree )
		else	( pathfinder (path++[(a,False,False)]) point us tree )


pathfinder path point (Leaf ws) tree	=
  let 
	pathtester a	=	[ (parttest node point (fst a)) | node<-path ]
	nnp		=	nn2 point (Leaf ws)
  in
  case ( nnp ) of
	EmptyTree	->	EmptyTree
	EmptyLeaf	->	EmptyLeaf
	NNPoint pnn	->	if	( or (pathtester pnn) )
				then	( findother tree point path (pathtester pnn) pnn )
				else	( NNPoint pnn )

parttest (pivot,coord,wing) point distmax = 
	if	( coord )
	then	( distmax > distance point (pivot,(snd point)) )
	else	( distmax > distance point ((fst point),pivot) )

findother Null	_ _ _ pnn	=	NNPoint pnn
findother (Leaf ws) _ _ _ pnn	=	NNPoint pnn
findother (Node bool a us vs) point ((pivot,coord,wing):path) (t:pathtester) pnn
	| t && wing	=	compnn pnn (nnk point (getLeafs us))
	| t		=	compnn pnn (nnk point (getLeafs vs))
	| wing		=	findother vs point path pathtester pnn
	| otherwise	=	findother us point path pathtester pnn

compnn pnn nno =
  case ( nno ) of
	EmptyTree	->	NNPoint pnn
	EmptyLeaf	->	NNPoint	pnn
	NNPoint	onn	->	NNPoint	(comp pnn onn)

comp pnn onn
	| (fst pnn) < (fst onn)	=	pnn
	| otherwise		=	onn


-- recupera todas as folhas de um arvore

getLeafs Null			=	[]
getLeafs (Leaf ws)		=	ws
getLeafs (Node bool b us vs)	=	getLeafs us ++ getLeafs vs

distance (a,b) (c,d)	=	(a-c)*(a-c) + (b-d)*(b-d)

nnk p []		=	EmptyTree
nnk p ws
	| array==[]	=	EmptyLeaf
	| otherwise	=	NNPoint ( minimum array )
  where	array		=	[ ((distance p w),w) | (w,bool)<-ws, bool, (p/=w) ]

--------------------------DELETE--------------------------

delete :: (Ord a) => Point a -> KDtree a -> KDtree a
auxDel :: (Eq a) => Point a -> [Pointk a] -> [Pointk a]

------------------------------------------------------------------------

delete p Null		=	Null
delete p (Leaf ws)	=	Leaf ( auxDel p ws )
delete p@(x,y) (Node bool a left right)
	|bool		=	if	( x <= a )
				then	Node bool a (delete p left) right
				else	Node bool a left (delete p right)
	|otherwise	=	if	( y <= a )
				then	Node bool a (delete p left) right
				else	Node bool a left (delete p right)

auxDel p []		=	[]
auxDel p ((w,del):ws)
	| p == w	=	(p,False):ws
	| otherwise	=	(w,del):(auxDel p ws)


-------------------QUICKSORTS------------------------------------

-- qsortx :: Ord a => [Point a] -> [Point a]
-- qsx :: Ord a => [Point a] -> [Point a] -> [Point a]
-- partitionx :: Ord a => Point a -> [Point a] -> [Point a] -> [Point a] -> ([Point a],[Point a])
-- qsorty :: Ord a => [Point a] -> [Point a]
-- qsy :: Ord a => [Point a] -> [Point a] -> [Point a]
-- partitiony :: Ord a => Point a -> [Point a] -> [Point a] -> [Point a] -> ([Point a],[Point a])
-- qsD :: Ord a => [PointDist a] -> [PointDist a] -> [PointDist a]
-- partitionD :: Ord a => PointDist a -> [PointDist a] -> [PointDist a] -> [PointDist a] -> ([PointDist a],[PointDist a])
--------------------------------------------------------------

qsortx 	   list		=	qsx list []
qsorty     list		=	qsy list []
qsort	   list		=	qs3 list []
qsx [] 	   list		=	list
qsx [x]    list		=	x:list
qsx (x:xs) list 	=	qsx left (x : qsx right list)
  where (left,right)	=	partitionx x xs [] []
qsy []     list		=	list
qsy [y]    list		=	y:list
qsy (y:ys) list 	=	qsy left (y : qsy right list)
  where (left,right)	=	partitiony y ys [] []
qs3 [] 	   list		=	list
qs3 [x]    list		=	x:list
qs3 (x:xs) list 	=	qs3 left (x : qs3 right list)
  where	(left,right)	=	partition3 x xs [] []
partitionx (x,y) [] l r =	(l,r)
partitionx (x,y) ((a,b):xs) l r
	| a <= x	=	partitionx (x,y) xs ((a,b):l) r
	| otherwise	=	partitionx (x,y) xs l ((a,b):r)
partitiony (x,y) [] l r =	(l,r)
partitiony (x,y) ((a,b):ys) l r
	| b <= y	= 	partitiony (x,y) ys ((a,b):l) r
	| otherwise	= 	partitiony (x,y) ys l ((a,b):r)
partition3 (d,x,y) [] l r=	(l,r)
partition3 (d,x,y) ((d1,a,b):xs) l r
	| d1 <= d	=	partition3 (d,x,y) xs ((d1,a,b):l) r
	| otherwise	=	partition3 (d,x,y) xs l ((d1,a,b):r)






