module Greedy where

import List
import Point
import Control.Exception
import System.IO

type Pointg a = (Point a,Point a)
type PointGr a = ((Point a),Int)
type PointDist a = (a,Point a,Point a)

istour[] = True
istour[a]= True

istour (a:rray) = 
	if ( elem a rray )
	then ( False )
	else ( istour rray )

dist2 (a,b) (c,d) = (a-c)*(a-c) + (b-d)*(b-d)

listaArestas :: (Num a) => [Point a] -> [PointDist a]
listaArestas [a] = []
listaArestas (a:xs) = [(dist2 a b,a,b) | b <- xs ]++listaArestas xs


filtraD :: [PointDist a] -> [Pointg a]
filtraD xs = [(a,b)|(d,a,b)<-xs]

filtraG :: [PointGr a] -> [Point a]
filtraG xs = [a|(a,grau)<-xs]

greedy pts = 	let
		 tour = filtraG (head (greedy2 pts))
		in assert ((length tour) == (length pts)) tour

greedy2 :: (Ord a, Read a,Num a) => [Point a] -> [[PointGr a]]
greedy2 xs =(aux (filtraD (qs(listaArestas xs))) [])

data (Ord a, Read a, Show a, (Show [[PointGr a]])) =>
    Condicao a =
	PertTourG01  [PointGr a] [PointGr a]	--apenas um dos pts estao no tour
	|PertTourG11 [PointGr a] [PointGr a]	--os 2 pts estao no tour e tem grau 1
	|PertTourG2		 		--algum dos pts tem grau 2
	|NotTour 				--ambos tem grau 0S
	deriving (Eq,Read,Show)

-- a e b sao pontos... juntos formam uma aresta!
aux :: (Eq a, Show a,Ord a, Read a) => [Pointg a] -> [[PointGr a]] -> [[PointGr a]]
aux [] tour = tour
aux ((a,b):listOrd) [] = aux listOrd [[(a,1),(b,1)]]
aux ((a,b):listOrd) tour =
	let tour01 xs ys = if (xs/=[])
		then (insereP b a (aumentaGrau a xs)):(tourSemX xs)
		else (insereP a b (aumentaGrau b ys)):(tourSemX ys)
	    tour11 xs ys = (juntaTour a b xs ys):(tourSemXY xs ys)
	    tourSemX xs = delete xs tour
	    tourSemXY xs ys = delete xs (tourSemX ys) in
	case (grauP (a,b) tour) of
		PertTourG01 xs ys -> aux listOrd (tour01 xs ys)
		PertTourG11 xs ys -> aux listOrd (tour11 xs ys)
		PertTourG2        -> aux listOrd tour
		NotTour           -> aux listOrd ([(a,1),(b,1)]:tour)

test :: (Eq a) => Point a -> [PointGr a] -> Bool
test a [] = False
test a list = or [ a==c | (c,_)<-list ]

--(a,b) aresta
grauP :: (Eq a,Show a,Ord a, Read a) => Pointg a -> [[PointGr a]] -> Condicao a
grauP (a,b) tour
	|(tourA/=[])&&(grauA==2) = PertTourG2
	|(tourB/=[])&&(grauB==2) = PertTourG2
	|(tourA/=[])&&(grauA==1)&&(tourB==[]) = PertTourG01 tourA []
	|(tourB/=[])&&(grauB==1)&&(tourA==[]) = PertTourG01 [] tourB
	|(tourA/=[])&&(grauA==1)&&(tourB/=[])&&(grauB==1) =
						PertTourG11 tourA tourB
	|otherwise   = NotTour
		where 	tourA = subTour a tour
			tourB = subTour b tour
			grauA= head[g|(c,g)<-tourA,a==c]
			grauB= head[g|(c,g)<-tourB,b==c]

subTour _ [] = []
subTour a (xs:tour)
	|(elem (a,2) xs) = xs
	|(elem (a,1) xs) = xs
	|otherwise   = subTour a tour
-- subTour a [] = []
-- subTour a (xs:tour)
-- 	|(test a xs) = xs
-- 	|otherwise   = subTour a tour

aumentaGrau :: (Eq a) => Point a -> [PointGr a] -> [PointGr a]
aumentaGrau a xs
	|aHead a xs     = ptoA:(tail xs)
	|otherwise      = (init xs)++[ptoA]
		where 	ptoA = head [(a,grau+1) | (c,grau)<-xs, a==c ]
--			listaSemA = delete (a,1) xs

-- insere b com a ja no tour
insereP :: (Eq a) => Point a -> Point a -> [PointGr a] -> [PointGr a]
insereP b a xs
	| aHead a xs       = ((b,1):xs)
	|otherwise	   = (xs++[(b,1)])

-- retorna se a eh head ou last
aHead :: (Eq a) => Point a -> [PointGr a] -> Bool
aHead a ((b,_):xs) = (a==b)

juntaTour :: (Eq a) => Point a -> Point a -> [PointGr a] -> [PointGr a] -> [PointGr a]
juntaTour a b xs ys
   |xs == ys  = xs

   |(aHead a xs)&&(aHead b ys)     =
   	((reverse (aumentaGrau a xs))++aumentaGrau b ys)

   |(aHead a xs)&&(not(aHead b ys)) =
   	(aumentaGrau b ys++aumentaGrau a xs)

   |(not(aHead a xs))&&(aHead b ys) =
   	(aumentaGrau a xs++aumentaGrau b ys)

   |not((aHead a xs)&&(aHead b ys)) =
   	(aumentaGrau a xs++(reverse (aumentaGrau b ys)))


qs [] = []
qs ((d,x,y):ys) = (qs (split (>) (d,x,y) ys) ++
 		((d,x,y): (qs (split (<=) (d,x,y) ys))))
 
split op a [] = []
split op (d,x,y) ((d1,x1,y1):xs)
 	|op d d1    = (d1,x1,y1):(split op (d,x,y) xs)
 	|otherwise  = (split op (d,x,y) xs)
	
ordenaA :: Ord a => [PointDist a] -> [PointDist a]
ordenaA [] = []
ordenaA ((d,x,y):ws) = (ordenaA left ++ [(d,x,y)] ++ ordenaA right)
  where left  = [(e,a,b) | (e,a,b)<-ws, e <= d]
	right = [(e,a,b) | (e,a,b)<-ws, e >  d]

peso (a: []) = 0
peso (a:xs) = (dist2 a (head xs)) + peso xs


-- qsort	   list		=	qs3 list []
-- 
-- qs3 [] 	   list		=	list
-- qs3 [x]    list		=	x:list
-- qs3 (x:xs) list 	=	qs3 left (x : qs3 right list)
--   where	(left,right)	=	partition3 x xs [] []
-- partition3 (d,x,y) [] l r=	(l,r)
-- partition3 (d,x,y) ((d1,a,b):xs) l r
-- 	| d1 <= d	=	partition3 (d,x,y) xs ((d1,a,b):l) r
-- 	| otherwise	=	partition3 (d,x,y) xs l ((d1,a,b):r)

