
-- TRABALHO 0, EXERCICIO 9

module Frp where

import Point
import List
import Control.Exception
import System.CPUTime
import KDTree
import Nn

---------------------------------FRP------------------------------------------------------------------

frp        :: (Num a, Ord a) => [Point a] -> [Point a]
mergeLeafs :: (Num a, Ord a) => KDtree a -> [Point a]
mergeList  :: (Num a, Ord a) => Bool -> a -> [Point a] -> [Point a] -> [Point a]
sortList   :: (Num a, Ord a) => Point a -> [Point a] -> Point a -> [Point a] -> [Point a]

------------------------------------------------------------------------------------------------------


frp [ ]		=	[ ]
frp [a]		=	[a]
frp xs		=	mergeLeafs (KDTree.build xs)


mergeLeafs (Leaf ws)			=	Nn.nn [ w | (w,bool)<-ws, bool ]
mergeLeafs (Node bool pivot us vs)	=	mergeList bool pivot (mergeLeafs us) (mergeLeafs vs)

mergeList bool pivot aside bside	= 
  let
	pax	=	snd(head(qsortx([ ((Nn.distance (pivot,(snd a)) a),a) | a<-aside] )))
	pbx	=	snd(head(qsortx([ ((Nn.distance (pivot,(snd b)) b),b) | b<-bside] )))
	pay	=	snd(head(qsortx([ ((Nn.distance ((fst a),pivot) a),a) | a<-aside] )))
	pby	=	snd(head(qsortx([ ((Nn.distance ((fst b),pivot) b),b) | b<-bside] )))
  in
	if	( bool )
	then	( sortList pax aside pbx bside )
	else	( sortList pay aside pby bside )


sortList p1 l1 p2 l2	= 
	(takeWhile (/=p1) l1)
	++
	(p1:(dropWhile (/=p2) l2))
	++
	((takeWhile (/=p2) l2))
	++
	(tail (dropWhile (/=p1) l1))

