module PQGreedy where

import Point
import Binpq
import NNKDTreeInt
import DeleteInt
import KDTreeInt
import Data.List(find,delete)
import Data.Maybe

pqgreedy ptos = let
		  kdtree = build ptos
		  binpq = constroi LeafPQ kdtree ptos
		  Just (d,p,q) = findmin binpq
		  kd = grauTo1 p (grauTo1 q kdtree)
		  tour = [[p,q]]
		in vamo_la (delmin binpq) kd tour

vamo_la LeafPQ _ tour = head tour
vamo_la binpq kdtree tour
	| graup1 == 2 = vamo_la (insertBinpq (delmin binpq)
			        (distancia p2 nnp2, p2, nnp2)) kdtree tour
	| graup2 == 2 = vamo_la (insertBinpq (delmin binpq)
			        (distancia p1 nnp1, p1, nnp1)) kdtree tour
	| graup1 == 0 && graup2 == 0 = vamo_la (delmin binpq) p1p2To1 ([p1,p2]:tour)
	| graup1 == 0 = vamo_la (delmin binpq) p1To1p2To2 (add_pto p2 p1 tour [])
	| graup2 == 0 = vamo_la (delmin binpq) p1To2p2To1 (add_pto p1 p2 tour [])
	| (p1 == head t1 && p2 == last t1) || (p1 == last t1 && p2 == head t1)
		= case (nnKDAux p1 p2to2) of
		     Just q -> vamo_la (insertBinpq (delmin binpq)
				       (distancia p1 nnp1f, p1, nnp1f)) kdtree tour
		     Nothing -> vamo_la LeafPQ kdtree tour
	| otherwise = vamo_la (delmin binpq) p1p2To2 (junta_tour p1 p2 t1 t2 f)
	where
	  Just (d,p1,p2) = findmin binpq
	  graup1 = grau p1 kdtree
	  graup2 = grau p2 kdtree
	  p1p2To1 = grauTo1 p2 (grauTo1 p1 kdtree)
	  p1p2To2 = grauTo2 p2 (grauTo2 p1 kdtree)
	  p1To1p2To2 = grauTo2 p2 (grauTo1 p1 kdtree)
	  p1To2p2To1 = grauTo1 p2 (grauTo2 p1 kdtree)
	  p1to2 = grauTo2 p1 kdtree
	  p2to2 = grauTo2 p2 kdtree
	  nnp1 = nnKD p1 kdtree
	  nnp2 = nnKD p2 kdtree
	  nnp1f = nnKD p1 p2to2
	  nnp2f = nnKD p2 p1to2
	  t1 = tour_parcial p1 tour
	  t2 = tour_parcial p2 tour
	  f = filter (\t -> t/=t1 && t/=t2) tour

junta_tour p1 p2 t1 t2 tour
	| p1 == head t1 = if p2 == head t2
			  then (reverse t1 ++ t2): tour
			  else (t2++t1): tour
	| p1 == last t1 = if p2 == head t2
			  then (t1++t2): tour
			  else (t1 ++ reverse t2): tour

add_pto _ _ [] final = final
add_pto p1 p2 (t:tour) final
	| p1 == head t = ((p2:t): final) ++ tour
	| p1 == last t = ((t++[p2]): final) ++ tour
	| otherwise = add_pto p1 p2 tour (t:final)

tour_parcial p (t:tour)
	| p == head t || p == last t = t
	| otherwise = tour_parcial p tour

constroi binpq _ [] = binpq
constroi binpq kdtree (p:ptos) =
	let
	  q = nnKD p kdtree
	  tree = insertBinpq binpq (distancia p q,p,q)
	in
	  constroi tree kdtree ptos

grau a (Leaf x) = let Just g = lookup a x
		  in g
grau (a,b) (Node disc value x y)
	| (disc == True && a <= value) || (disc == False && b <= value) =
		grau (a,b) x
	| otherwise =
		grau (a,b) y

