module Binpq where

import Data.Maybe

data Binpq a = LeafPQ | NodePQ a (Binpq a) (Binpq a)
	deriving Show

merge :: Ord a => Binpq a -> Binpq a -> Binpq a

merge LeafPQ x = x
merge x LeafPQ = x
merge t1@(NodePQ a1 x1 y1) t2@(NodePQ a2 x2 y2) 
	| a1 < a2	= NodePQ a1 (merge y1 t2) x1
	| a1 >= a2	= NodePQ a2 (merge t1 y2) x2

------------------------------------------

insertBinpq :: Ord a => Binpq a -> a -> Binpq a

insertBinpq LeafPQ k = NodePQ k LeafPQ LeafPQ
insertBinpq (NodePQ a x y) k = merge (NodePQ k LeafPQ LeafPQ) (NodePQ a x y)

------------------------------------------

findmin :: Binpq a -> Maybe a

findmin LeafPQ = Nothing
findmin (NodePQ a x y) = Just a

------------------------------------------

delmin :: Ord a => Binpq a -> Binpq a

delmin LeafPQ = LeafPQ
delmin (NodePQ a x y) = merge x y

------------------------------------------

isBinpq :: Ord a => Binpq a -> Bool

isBinpq LeafPQ = True
isBinpq (NodePQ a LeafPQ LeafPQ) = True
isBinpq (NodePQ a LeafPQ t@(NodePQ a1 x1 y1)) 
	| a1 > a		= isBinpq t
	| otherwise		= False

isBinpq (NodePQ a t@(NodePQ a1 x1 y1) LeafPQ) 
	| a1 > a		= isBinpq t
	| otherwise		= False

isBinpq (NodePQ a t1@(NodePQ a1 x1 y1) t2@(NodePQ a2 x2 y2)) 
	| a1 > a && a2 > a	= isBinpq t1 && isBinpq t2
	| otherwise		= False
