module Point where

import System.IO

type Point a = (a,a)

readPoints :: (Read a) => [String] -> IO [Point a]
readPoints xs = isEOF >>= \eof -> if eof
                                  then return (map read (reverse xs))
                                  else getLine >>= \ln -> readPoints (ln:xs)

readIntPts :: [String] -> IO [Point Int]
readIntPts = readPoints

distancia (x0,y0) (x1,y1) = (x0-x1)*(x0-x1) + (y0-y1)*(y0-y1)

compX (x1,y1) (x2,y2) = if x1 > x2 then GT
			else if x1 == x2 then EQ
			else LT

compY (x1,y1) (x2,y2) = if y1 > y2 then GT
			else if y1 == y2 then EQ
			else LT

distcmp p p0 p1 = let
 	  d0 = distancia p p0
          d1 = distancia p p1
	in if d0 < d1 then LT
	   else if d0 == d1 then EQ
	   else GT

showPoints :: (Show a) => [Point a] -> String
showPoints pts = unlines (map show pts)


