module NN where

import Data.List(nub)
import Point
import KDTreeBool
import NNKDTreeBool
import DeleteBool

nn :: (Num a, Ord a) => [Point a] -> [Point a]

toureval ptos = nn ptos

nn ptos = let
	    tour = [head ptos]
	    kdtree = build (tail ptos)
	  in nnAux tour kdtree 1 (length ptos)

nnAux tour kdtree l_atual l_total
	| l_atual == l_total = tour
	| otherwise = let next = nnKD (head tour) kdtree
		      in nnAux (next:tour) (deleteKD next kdtree) (l_atual+1) l_total

------------------------------------------

istour :: (Num a, Ord a) => [Point a] -> Bool

istour [] = True
istour [a] = True
istour xs = if length (nub xs) == length xs
	    then let kdtree = build xs
	    	 in  isNNtour (reverse xs) kdtree
	    else False

isNNtour [] _ = True
isNNtour [a] _ = True
isNNtour (a:(b:xs)) kdtree
	| b == nnKD a kdtree = isNNtour (b:xs) (deleteKD a kdtree)
	| otherwise = False
