module NNKDTreeInt where

import Point
import KDTreeInt
import Data.List(minimumBy,delete)

nnKD :: (Ord a, Num a) => Point a -> KDtree a -> Point a

nnKD p t = let Just q = nnKDAux p t
	   in q

nnKDAux p@(x,y) (Leaf a) = vizProxKD p a
nnKDAux p@(x,y) (Node True a l r)
	| x <= a	= case (nnKDAux p l) of
			     Just ql -> if distancia p ql <= (x-a)*(x-a) 
					then Just ql
					else case (nnKDAux p r) of
						Just qr -> Just (minimumBy (dist1 p) [ql,qr])
						Nothing -> Just ql
			     Nothing -> case (nnKDAux p r) of
					   Just qr -> Just qr
					   Nothing -> Nothing
	| otherwise	= case (nnKDAux p r) of
			     Just qr -> if distancia p qr < (x-a)*(x-a) 
					then Just qr
					else case (nnKDAux p l) of
						Just ql -> Just (minimumBy (dist1 p) [ql,qr])
						Nothing -> Just qr
			     Nothing -> case (nnKDAux p l) of
					   Just ql -> Just ql
					   Nothing -> Nothing

nnKDAux p@(x,y) (Node False a l r)
	| y <= a	= case (nnKDAux p l) of
			     Just ql -> if distancia p ql <= (y-a)*(y-a) 
					then Just ql
					else case (nnKDAux p r) of
						Just qr -> Just (minimumBy (dist1 p) [ql,qr])
						Nothing -> Just ql
			     Nothing -> case (nnKDAux p r) of
					   Just qr -> Just qr
					   Nothing -> Nothing
	| otherwise	= case (nnKDAux p r) of
			     Just qr -> if distancia p qr < (y-a)*(y-a) 
					then Just qr
					else case (nnKDAux p l) of
						Just ql -> Just (minimumBy (dist1 p) [ql,qr])
						Nothing -> Just qr
			     Nothing -> case (nnKDAux p l) of
					   Just ql -> Just ql
					   Nothing -> Nothing

vizProxKD p pts = let
	filtraTrue = filter (\(a,b) -> b /= 2) pts
	q = minimumBy (dist2 p) filtraTrue
	in if filtraTrue /= []
	   then if p /= fst q
		then Just (fst q)
		else vizProxKD p (delete q pts)
	   else Nothing

dist2 p p0 p1 = let
 	  d0 = distancia p (fst p0)
          d1 = distancia p (fst p1)
	in if d0 < d1 then LT
	   else if d0 == d1 then EQ
	   else GT

dist1 p p0 p1 = let
 	  d0 = distancia p p0
          d1 = distancia p p1
	in if d0 < d1 then LT
	   else if d0 == d1 then EQ
	   else GT

