module KDTreeBool where

import Point
import Data.List(sortBy)

data KDtree a =
	  Leaf [(Point a, Bool)]
	| Node Bool a (KDtree a) (KDtree a)
	deriving Show

build :: Ord a => [Point a] -> KDtree a

build list =
	let
	  tam = length list
	  mediana = last (take (div tam 2) x)
	  medX = fst mediana
	  menorX = filter (\(a,b) -> a <= medX) x
	  maiorX = filter (\(a,b) -> a > medX) x
	  x = sortBy compX list
	in
	  if tam <= 8
	  then Leaf (map (\p -> (p,True)) x)
	  else Node True medX
		    ( buildAux False menorX (sortBy compY menorX) )
		    ( buildAux False maiorX (sortBy compY maiorX) )

buildAux disc x y
	| tam <= 8	= Leaf (map (\p -> (p,True)) x)
	| disc == True	= Node True medX
			       ( buildAux False (menorX x) (menorX y) )
			       ( buildAux False (maiorX x) (maiorX y) )
	| otherwise	= Node False medY
			       ( buildAux True (menorY x) (menorY y) )
			       ( buildAux True (maiorY x) (maiorY y) )
	where tam = length x
	      medX = fst (mediana x)
	      medY = snd (mediana y)
	      mediana ls = last (take (div tam 2) ls)
	      menorX ls = filter (\(a,b) -> a <= medX) ls
	      menorY ls = filter (\(a,b) -> b <= medY) ls
	      maiorX ls = filter (\(a,b) -> a > medX) ls
	      maiorY ls = filter (\(a,b) -> b > medY) ls

