module DeleteInt where

import Point
import KDTreeInt

grauTo1 a (Leaf x) = Leaf (change1 a x [])
grauTo1 p@(a,b) (Node disc value x y)
	| (disc == True && a <= value) || (disc == False && b <= value) =
		Node disc value (grauTo1 p x) y
	| otherwise =
		Node disc value x (grauTo1 p y)

grauTo2 a (Leaf x) = Leaf (change2 a x [])
grauTo2 p@(a,b) (Node disc value x y)
	| (disc == True && a <= value) || (disc == False && b <= value) =
		Node disc value (grauTo2 p x) y
	| otherwise =
		Node disc value x (grauTo2 p y)

change1 a [] final = final
change1 a ((p,b):x) final
	| a == p	= final ++ ((p,1):x)
	| otherwise	= (change1 a x ((p,b):final))

change2 a [] final = final
change2 a ((p,b):x) final
	| a == p	= final ++ ((p,2):x)
	| otherwise	= (change2 a x ((p,b):final))
