module DeleteBool where

import Point
import KDTreeBool

deleteKD :: Ord a => Point a -> KDtree a -> KDtree a

deleteKD a (Leaf x) = Leaf (change_bool a x [])
deleteKD (a,b) t@(Node disc value x y)
	| (disc == True && a <= value) || (disc == False && b <= value) =
		Node disc value (deleteKD (a,b) x) y
	| otherwise =
		Node disc value x (deleteKD (a,b) y)

change_bool a [] final = final
change_bool a ((p,b):x) final
	| a == p	= final ++ ((p,False):x)
	| otherwise	= (change_bool a x ((p,b):final))

