module KDTree where

import Point
import Data.List(sortBy, nub)

data KDtree a =
	  Leaf [Point a]
	| Node Bool a (KDtree a) (KDtree a)
	deriving Show

build :: Ord a => [Point a] -> KDtree a

build list =
	let
	  tam = length list
	  mediana = last (take (div tam 2) x)
	  medX = fst mediana
	  menorX = filter (\(a,b) -> a <= medX) x
	  maiorX = filter (\(a,b) -> a > medX) x
	  x = sortBy compX list
	in
	  if tam <= 8
	  then Leaf list
	  else Node True medX
		    ( buildAux False menorX (sortBy compY menorX) )
		    ( buildAux False maiorX (sortBy compY maiorX) )

buildAux disc x y
	| tam <= 8	= Leaf x
	| disc == True	= Node True medX
			       ( buildAux False (menorX x) (menorX y) )
			       ( buildAux False (maiorX x) (maiorX y) )
	| otherwise	= Node False medY
			       ( buildAux True (menorY x) (menorY y) )
			       ( buildAux True (maiorY x) (maiorY y) )
	where tam = length x
	      medX = fst (mediana x)
	      medY = snd (mediana y)
	      mediana ls = last (take (div tam 2) ls)
	      menorX ls = filter (\(a,b) -> a <= medX) ls
	      menorY ls = filter (\(a,b) -> b <= medY) ls
	      maiorX ls = filter (\(a,b) -> a > medX) ls
	      maiorY ls = filter (\(a,b) -> b > medY) ls

------------------------------------------

isKDtree :: (Num a, Ord a) => KDtree a -> Bool

isKDtree (Leaf a) = let tam = length a
		    in if (tam <= 8) then True
		       else False
isKDtree (Node d a x y) = case (isKDAux d (Node d a x y)) of
			     Just b -> True
			     Nothing -> False

isKDAux d (Leaf a) = let tam = length a
		     in if (tam <= 8) then Just a
		       else Nothing
isKDAux d (Node disc value x y)
	| Just f <- isKDAux (not d) x,
	  Just g <- isKDAux (not d) y,
	  testa d value (<=) f,
	  testa d value (>) g		= Just (f++g)
	| otherwise			= Nothing

compaX v op [] = True
compaX v op ((a,b):x)
	| op a v	= compaX v op x
	| otherwise	= False

compaY v op [] = True
compaY v op ((a,b):x)
	| op b v	= compaY v op x
	| otherwise	= False

testa d v op list
	| d == True	= compaX v op list
	| d == False	= compaY v op list



