module Greedy where

import Point
import Data.List(sortBy)

greedy ptos = let
		arestas = sortBy (dist) (constroi_arestas ptos)
		((p,q),d) = head arestas
		tour = [[p,q]]
		graus = inicializa_graus ptos
		g = muda_grau 1 p (muda_grau 1 q graus []) []
	      in
		fazTudo tour (tail arestas) g

fazTudo tour [] _ = head tour
fazTudo tour (a:arestas) graus = 
	let
	  p1 = fst (fst a)
	  p2 = snd (fst a)
	  graup1 = ret_grau p1 graus
	  graup2 = ret_grau p2 graus
	  tour1 = tour_parcial p1 tour
	  tour2 = tour_parcial p2 tour
	  f = filter (\t -> t/=tour1 && t/=tour2) tour
	in 
	  if graup1 == 2 || graup2 == 2
	  then fazTudo tour arestas graus
	  else if graup1 == 0 && graup2 == 0
	       then fazTudo ([p1,p2]:tour) arestas (muda_grau 1 p2 (muda_grau 1 p1 graus []) [])
	       else if graup1 == 0
		    then fazTudo (add_pto p2 p1 tour []) arestas 
				 (muda_grau 1 p1 (muda_grau 2 p2 graus []) [])
		    else if graup2 == 0
		         then fazTudo (add_pto p1 p2 tour []) arestas 
			 	      (muda_grau 1 p2 (muda_grau 2 p1 graus []) [])
		         else if tour1 == tour2		-- fecha ciclo
			      then fazTudo tour arestas graus
			      else fazTudo (junta_tour p1 p2 tour1 tour2 f) arestas
					   (muda_grau 2 p1 (muda_grau 2 p2 graus []) [])

inicializa_graus ptos = zip ptos (replicate (length ptos) 0)

ret_grau p xs = let Just q = lookup p xs
		in q

junta_tour p1 p2 t1 t2 tour
	| p1 == head t1 = if p2 == head t2
			  then (reverse t1 ++ t2): tour
			  else (t2++t1): tour
	| p1 == last t1 = if p2 == head t2
			  then (t1++t2): tour
			  else (t1 ++ reverse t2): tour

add_pto _ _ [] final = final
add_pto p1 p2 (t:tour) final
	| p1 == head t = ((p2:t): final) ++ tour
	| p1 == last t = ((t++[p2]): final) ++ tour
	| otherwise = add_pto p1 p2 tour (t:final)

muda_grau _ _ [] final = final
muda_grau g a (p:x) final
	| a == fst p	= final ++ ((fst p,g):x)
	| otherwise	= muda_grau g a x (p:final)

tour_parcial p (t:tour)
	| p == head t || p == last t = t
	| otherwise = tour_parcial p tour

constroi_arestas [] = []
constroi_arestas (a:x) = 
	let par a b = ((a,b),distancia a b)
	in  map (par a) x ++ constroi_arestas x

dist (pp0,d0) (pp1,d1) = if d0 < d1 then LT
			 else if d0 == d1 then EQ
			 else GT
