module Frp where

import KDTree
import Point
import Data.List(maximumBy,minimumBy,delete)

frp :: (Ord a, Num a) => [Point a] -> [Point a]

frp list = frpAux (build list)

frpAux (Leaf a) = nn a
frpAux (Node d a x y) = merge d (frpAux x) (frpAux y)

merge _ [] y = y
merge _ x [] = x
merge d x y
	| d == True	= let maiorX = maximumBy compX x
			      menorX = minimumBy compX y
			  in  (takeWhile (/=maiorX) x) ++ [maiorX] ++
			      (dropWhile (/=menorX) y) ++
			      (takeWhile (/=menorX) y) ++
			      tail (dropWhile (/=maiorX) x)
	| d == False	= let maiorY = maximumBy compY x
			      menorY = minimumBy compY y
			  in  (takeWhile (/=maiorY) x) ++ [maiorY] ++
			      (dropWhile (/=menorY) y) ++
			      (takeWhile (/=menorY) y) ++
			      tail (dropWhile (/=maiorY) x)

nn ptos = if ptos == []
	  then []
	  else let tour = [head ptos]
		   nontour = tail ptos
	       in nnAux tour nontour

nnAux tour [] = tour
nnAux tour nontour =
	let next = vizProx (last tour) nontour
	in  nnAux (tour++[next]) (delete next nontour)

vizProx p pts = minimumBy (dist p) pts

dist p p0 p1 = let
 	  d0 = distancia p p0
          d1 = distancia p p1
	in if d0 < d1 then LT
	   else if d0 == d1 then EQ
	   else GT
