module Kdtree where

import Point


data KDtree  a =   Folha  [Point a]
		| Interno a Bool (KDtree a) (KDtree a)
		deriving Show

build::(Integral a)=> [Point a]-> KDtree a

build xs = make xs True

make:: (Integral a) => [Point a] -> Bool -> KDtree a

make xs bool = let meio = split xs bool in
		if((length xs) <= 8)
		then Folha xs
		else
	            if(bool) then
	       		if([(a,b) | (a,b)<-xs, a <= meio]==[])||([(a,b) | (a,b)<-xs, a >  meio]==[])
	         	then make xs (not bool)
		 	else Interno meio bool (make ( [(a,b) | (a,b)<-xs, a <= meio]) (not bool) ) (make ( [(a,b) | (a,b)<-xs, a >  meio]) (not bool) )
                    else
	       	        if([(a,b) | (a,b)<-xs, b <= meio]==[])||([(a,b)| (a,b)<-xs, b> meio]==[])
			then make xs (not bool) -- isso evita lista vazia
	                else Interno meio bool (make ([ (a,b) | (a,b)<-xs, b <= meio]) (not bool) ) (make ([ (a,b) | (a,b)<-xs, b >  meio]) (not bool) )

split:: (Integral a) => [Point a]-> Bool -> a

split xs bool = if(bool)
		then div ( fst(minimum xs) + fst (maximum xs) ) 2
		else div ( (head [ b | (a,b)<-xs, b == minimum [b | (a,b)<-xs]]) +
			   (head [ b | (a,b)<-xs, b == maximum [b | (a,b)<-xs]])) 2

isKDtree:: (Ord a) => KDtree a -> Bool

isKDtree (Folha xs) = True

isKDtree tree = if(length(isHelp tree)>0)
		then True
		else False

isHelp (Interno pivot b (Folha xs) (Folha ys) ) = if((aux pivot b True xs) && (aux pivot b False ys))
							then xs++ys
							else []

isHelp (Interno pivot b c (Folha ys ) ) = let
					  cx = isHelp c in
					if(aux pivot b False ys)&&((length cx)>0)
					then	if(aux pivot b True cx )
						then ( cx ++ ys )
						else []
					else []

isHelp (Interno pivot b (Folha xs ) c ) = let
					  cx = isHelp c in
					if(aux pivot b True xs)&&(length cx >0)
					then if(aux pivot b False cx )
						then ( cx ++ xs )
						else []
					else []

isHelp (Interno pivot b c d ) = let
				dx = isHelp d
				cx = isHelp c in
				  if(( length cx >0 )&&( length dx >0 ) )
				  then if(aux pivot b True cx )&&( aux pivot b False dx )
					then ( cx ++ dx )
					else []
				else []

aux pivot bool op (a:[]) = if(bool)
			then if(op)
				then((fst a) <= pivot)
				else((fst a) > pivot)
			else if(op)
				then((snd a) <= pivot)
				else((snd a) > pivot)

aux pivot bool op (a:xs) = if(bool)
			then if(op)
				then((fst a) <= pivot) && (aux pivot bool op xs)
				else((fst a) > pivot) && (aux pivot bool op xs)
			else if(op)
				then((snd a) <= pivot) && (aux pivot bool op xs)
				else((snd a) > pivot) && (aux pivot bool op xs)

rebuild::(KDtree a)->[Point a]

rebuild (Folha xs) = xs

rebuild (Interno a bool ys xs ) = (rebuild ys) ++ (rebuild xs)

distancia:: ( Ord a, Num a ) => Point a -> Point a -> a

distancia (x,y) (a,b) = ( (x- a) * (x-a) +  (y-b) * (y -b) )


del2:: Eq a => (a) -> [a] -> [a]

del2 a []   = []

del2 a (b:xs) = if(a==b)
		then (xs)
		else b:(del2 a xs)

proximo:: ( Num a, Ord a ) =>Point a -> [Point a] -> Point a

proximo x (a:[]) = a

proximo x xs = snd ( minimum [(distancia b x, b) | b<-xs])


nnKDtree:: (Ord a , Num a) => Point a -> KDtree a -> Point a

nnKDtree a (Folha xs) = proximo a xs

nnKDtree (x,y) (Interno num True xs  ys) = if(x>num)
						then let atual = nnKDtree (x,y) ys in
							if(distancia atual (x,y))>(distancia (x,y) (num,y))
								then let outroAtual = nnKDtree (x,y) xs in
									if(distancia (x,y) atual) > (distancia (x,y) outroAtual)
									then outroAtual
									else atual
								else atual
						else let atual = nnKDtree (x,y) xs in
							if(distancia atual (x,y))>(distancia (x,y) (num,y) )
							then let outroAtual = nnKDtree (x,y) ys in
								if(distancia (x,y) atual) > (distancia (x,y) outroAtual)
									then outroAtual
									else atual
							else atual

nnKDtree (x,y) (Interno num False xs  ys) = if(y> num)
						then let atual = nnKDtree (x,y) ys in
							if(distancia atual (x,y))>(distancia (x,y) (x, num))
								then let outroAtual = nnKDtree (x,y) xs in
									if(distancia (x,y) atual) > (distancia (x,y) outroAtual)
									then outroAtual
									else atual
								else atual
						else let atual = nnKDtree (x,y) xs in
							if(distancia atual (x,y))>(distancia (x,y) (x,num))
								then let outroAtual = nnKDtree (x,y) ys in
									if(distancia (x,y) atual) > (distancia (x,y) outroAtual)
									then outroAtual
									else atual
								else atual

delete::(Integral a) =>(Point a) -> (KDtree a) ->(KDtree a)

delete ponto (Folha xs) = let lista = (del2 ponto xs) in
			if(lista == [])
			then (build xs)
			else Folha lista

delete ponto (Interno a b (Folha xs) (Folha ys)) = if(b)
				then if((fst ponto)>a) then let lista = del2 ponto ys in
								if(lista==[]) then build (rebuild (Interno a b (Folha xs) (Folha lista)))
									else Interno a b (Folha xs) (Folha lista)
						       else let lista = del2 ponto xs in
								if(lista==[]) then build (rebuild (Interno a b (Folha lista) (Folha ys)))
									else Interno a b (Folha lista) (Folha ys)
				else if((snd ponto)>a) then let lista = del2 ponto ys in
								if(lista==[]) then build (rebuild (Interno a b (Folha xs) (Folha lista)))
									else Interno a b (Folha xs) (Folha lista)
						       else let lista = del2 ponto xs in
								if(lista==[]) then build (rebuild (Interno a b (Folha lista) (Folha ys)))
									else Interno a b (Folha lista) (Folha ys)

delete ponto (Interno a b xs (Folha ys)) = if(b)
				then if((fst ponto)>a) then let lista = del2 ponto ys in
								if(lista==[]) then build (rebuild (Interno a b xs (Folha lista)))
									else Interno a b xs (Folha lista)
						       else Interno a b (delete ponto xs) (Folha ys)
				else if((snd ponto)>a) then let lista = del2 ponto ys in
								if(lista==[]) then build (rebuild (Interno a b xs (Folha lista)))
									else Interno a b xs (Folha lista)
						       else Interno a b (delete ponto xs) (Folha ys)

delete ponto (Interno a b (Folha xs) ys) = if(b)
				then if((fst ponto)<=a) then let lista = del2 ponto xs in
								if(lista==[]) then build (rebuild (Interno a b (Folha lista) ys))
									else Interno a b (Folha lista) ys
						       else Interno a b (Folha xs) (delete ponto ys)
				else if((snd ponto)<=a) then let lista = del2 ponto xs in
								if(lista==[]) then build (rebuild (Interno a b (Folha lista) ys))
									else Interno a b (Folha lista) ys
						       else Interno a b (Folha xs) (delete ponto ys)

delete ponto (Interno a b xs ys) = if(b)
				then if((fst ponto)>a) then Interno a b xs (delete ponto ys)
						       else Interno a b (delete ponto xs) ys
				else if((snd ponto)>a) then Interno a b xs (delete ponto ys)
						       else Interno a b (delete ponto xs) ys

