module Greedy where

import Kdtree
import Point

greedy::( Ord a, Num a) => [Point a]->[Point a]

converte (a:xs) = if((fst a) == (fst (head xs)))||((fst a)==(snd (head xs)))
		then [snd a,fst a] ++ mudaHelp (fst a) xs
		else [fst a,snd a] ++ mudaHelp (snd a) xs

mudaHelp a (b:[]) = if( a == (fst b) )
			then [snd b]
			else [fst b]

mudaHelp a (b:xs) = if( a == (fst b) )
			then [snd b]++ mudaHelp (snd b) xs
			else [fst b]++ mudaHelp (fst b) xs

greedy xs =   converte (greedyHelp (qs (makeDist xs)) (makeGraus xs) [])

greedyHelp [] pon tour  = head tour

greedyHelp ( (d,(x,y)) :dis) pon tour
		|(gx==2 || gy ==2) =  greedyHelp dis pon tour
		|(gx + gy == 1)    =  greedyHelp dis newPon newAddTour
		|(gx + gy == 2)    =  if (checkCycle (x,y) tour)
			      		then greedyHelp dis pon tour
					else greedyHelp dis newPon newMergeTour
		| otherwise =  greedyHelp dis newPon ([(x,y)]:tour) --dois cabacos
		where gx = getGrau x pon
		      gy = getGrau y pon
		      newAddTour = setTour (x,y) tour -- junta uma aresta em um tour pronto
		      newMergeTour =  merge2Tour (x,y) tour -- mescla dois tour
		      newPon = setGrau y ( setGrau x pon) -- aumenta grau dos dois pontos

merge2Tour (x,y) tour = let tx = getTour x tour
			    ty = getTour y tour in
			if(x==fst(head tx))||(x==snd(head tx))
			then -- x no comeco de seu tour
				if(y==fst(head ty))||(y==snd(head ty))
				then ((reverse tx)++((x,y):ty)):(del2 tx ( del2 ty tour))
				else ((reverse tx)++((x,y):(reverse ty))): (del2 tx ( del2 ty tour ))
			else -- x no final de seu tour
				if(y==fst(head ty))||(y==snd(head ty))
				then (tx++((x,y):ty)):(del2 tx ( del2 ty tour))
				else (tx++((x,y):(reverse ty))): (del2 tx ( del2 ty tour ))

getTour x (a:tour) = if(x==fst (head a))||(x==snd (head a))||(x==fst(last a))||(x==snd(last a))
			then a
			else getTour x tour

checkCycle (x,y) (a:xs)
	 |(x== (fst (head a))) ||( x ==(snd (head a))) = if(y== (fst (last a))) ||( y ==(snd (last a)))
								then True
								else False
	 |(y== (fst (head a))) ||( y ==(snd (head a))) = if(x== (fst (last a))) ||( x ==(snd (last a)))
								then True
								else False
	 |(x== (fst (last a))) ||( x ==(snd (last a))) = if(y== (fst (head a))) ||( y ==(snd (head a)))
								then True
								else False
	 |(y== (fst (last a))) ||( y ==(snd (last a))) = if(x== (fst (head a))) ||( x ==(snd (head a)))
								then True
								else False
	 | otherwise = checkCycle (x,y) xs

makeDist (a:[]) = []

makeDist (a:xs) =  [((distancia a b),(a,b))| b<-xs]++ (makeDist xs)

mergeLista [] xs = xs

mergeLista xs [] = xs

mergeLista (a:xs) (b:ys) = if(a<b)
			   then a: (mergeLista xs (b:ys))
			   else b: (mergeLista (a:xs) ys)

makeGraus xs = zip xs (replicate ((length xs)) 0)

--inclui uma aresta em uma ponta dos tours jah existentes
setTour a (b:xs) = if( fst a == fst (head b))||( fst a == snd (head b))||
		     ( snd a == fst (head b))||( snd a == snd (head b))
		     then (a:b):xs
		     else if( fst a == fst (last b))||( fst a == snd (last b))||
		     ( snd a == fst (last b))||( snd a == snd (last b))
		     then (b++[a]):xs
		     else b: (setTour a xs)

-- aumenta o grau do ponto
setGrau a (b:xs) = if(a==(fst b)) then (a, (snd b)+1):xs else (b:(setGrau a xs))

-- busca o grau do ponto
getGrau a (b:xs) = if(a==(fst b)) then snd b else getGrau a xs

sort2 xs = foldl ins [] xs

ins [] a = [a]

ins (b:xs) a = if(a<b) then a:(b:xs) else b:(ins xs a)

qs [] = []

qs ((a,b):x) = (qs (splitqs (<) (a,b) x) ++ ((a,b):qs (splitqs (>) (a,b) x)))

splitqs op a [] = []

splitqs op a (b:x) = if op a b
                   then (splitqs op a x)
                   else b:(splitqs op a x)

