module Frp where

import Point
import Nn
import Kdtree

frp::(Integral a) =>[Point a]->[Point a]

frp [] = []

frp (a:[]) = [a]

frp xs = frpHelp (build xs)

frpHelp (Folha xs) = nn xs

frpHelp (Interno a bool (Folha xs) (Folha ys)) = if(bool)
						then let mx = (minimum xs) ;my = (minimum ys) in ( ( nn (mx :(del2 mx xs)) )) ++ ( nn (my:(del2 my ys)) )
						else let mx = (min_y xs) ;my = (min_y ys)     in ( ( nn (mx:(del2 mx xs )))) ++  (nn (my:(del2 my ys )))

frpHelp (Interno a bool (Folha xs) ys ) =  let  py = frpHelp ys in
					if(bool)
					then let mx = (minimum xs); my = (minimum py) in ( ( nn (mx:(del2 mx xs )) )) ++ (my:(del2 my py) )
					else let mx = (min_y xs);   my = (min_y py)   in ( ( nn (mx:(del2 mx xs )) )) ++ (my:(del2 my py) )

frpHelp (Interno a bool xs (Folha ys)  ) = let  px = frpHelp xs in
					if(bool)
					then let mx = (minimum px); my = (minimum ys) in ( (mx:(del2 mx px) ) ) ++ (nn (my:(del2 my ys)))
					else let mx = (min_y px);   my = (min_y ys)   in ( (mx:(del2 mx px))) ++ (nn (my:(del2 my ys)))

frpHelp (Interno a bool ys xs  ) = let  px = frpHelp xs
					py = frpHelp ys in
					if(bool)
					then let mx = (minimum px); my = (minimum py) in ( (my:(del2 my py))) ++ (mx:(del2 mx px))
					else let mx = (min_y px); my = (min_y py)     in ( (my:(del2 my py))) ++ (mx:(del2 mx px))

min_y::(Ord a)=> [Point a] -> Point a

min_y xs = head [(a,b)|(a,b)<-xs, b == minimum [b | (a,b)<-xs] ]
