-- #############################
-- EXERCICIO 4
-- #############################
module Binpq where
import KDtree
import Point

data Binpq a = Null
		|Node1   a
		        (Binpq a)
                        (Binpq a)
	deriving Show

--merge (x,a,y) (u,b,v) =
--                      |a < b = merge ((u,b,v),a,x)
--                      |otherwise = (merge (x,a,y)v,b,u)

-- -----------------------------
-- MERGE
-- -----------------------------

--merge :: (Ord a) => Binpq a -> Binpq a -> Binpq a
merge Null ys = ys
merge xs Null = xs

merge (Node1 a xs ys) (Node1 b ux vx) = if (a < b)
                                          then (Node1 a (merge ys (Node1 b ux vx)) xs)
                                        else (Node1 b (merge (Node1 a xs ys) vx) ux)

-- -----------------------------
-- INSERT
-- -----------------------------
--insert :: Ord a => Binpq a -> a -> Binpq a
insert (Node1 a xs ys) b = merge (Node1 a xs ys) (Node1 b Null Null)

-- -----------------------------
-- MINIMO
-- -----------------------------
--mim :: Ord a => Binpq a -> a
mim (Node1 a xs ys) = takemim (insert (Node1 a xs ys) a)
takemim (Node1 b xs ys) = b


-- -----------------------------
-- DELETE MINIMO
-- -----------------------------
--delmim :: Ord a=> Binpq a -> Binpq a
delmim (Node1 a xs yx) = delet (merge (Node1 a xs yx) Null)
delet (Node1 b xs yx) = merge xs yx

-- #############################
-- EXERCICIO 5 (isbinpq)
-- #############################
--isbinpq:: Ord a => Binpq a -> Bool
isbinpq (Node1 d as bs) = checkBinpq d (merge as bs)

checkBinpq a Null = True
checkBinpq a (Node1 c dx cx) = if (a <= c)
                                 then (checkBinpq2 a cx)
				else False

checkBinpq2 a Null = True
checkBinpq2 a (Node1 c dx cx) = if (a <= c)
                                 then (checkBinpq c dx)
				else False