module Point where

-- import module 'System.IO' that defines IO functions
import System.IO

-- the type 'Point a' is defined as a pair of coordinates
type Point a = (a,a)

-- 'readpoints' maps a list of 'String' to an 'IO' list of 'Point a'
--  'a' is restricted by '(Read a)' to be readable

readPoints :: (Read a) => [String] -> IO [Point a]


readPoints xs = isEOF >>= \eof -> if eof
                                  then return (map read (reverse xs))
                                  else getLine >>= \ln -> readPoints (ln:xs)

-- 'readIntPts' is a specific instance of 'readPoints' to read points with
--              Int coordinates
readIntPts :: [String] -> IO [Point Int]
readIntPts = readPoints

dist :: (Floating b) => (Point Int, Point Int) -> b
dist (p0,p1) = sqrt(fromIntegral (sqrdist (p0,p1)))

sqrdist :: (Point Int, Point Int) -> Int
sqrdist ((x0,y0), (x1,y1)) = (x0-x1)^2+(y0-y1)^2


-- 'showPoints' points list to String 

showPoints :: (Show a) => [Point a] -> String

showPoints pts = unlines (map show pts)


