-- #############################
-- EXERCICIO 1 (build)
-- #############################

----------------------------
-- KD-Tree - building
----------------------------
module KDtree where
import Point

--main = putStr (show (build pontos280))

   
data Kdtree a = Leaf [Ponta a]
                |Node Bool
                      a
                     (Kdtree a)
                     (Kdtree a)
	deriving Show

type Ponta a = (a,a)
	
xcoord (x,y) = x
ycoord (x,y) = y

build :: Ord a=> [Ponta a] -> Kdtree a  
build [a] = Leaf [a]
build xs = aux True (reverse (qs xs))

aux _ [a] = Leaf [a]
aux bool xs = if bool == True
                then Node (bool) (medio xs) (aux (not bool) (esq xs)) (aux (not bool) (dir xs))
              else  Node (bool) (media xs) (aux (not bool) (esq xs)) (aux (not bool) (dir xs))
              
                                    
-- --------------------------
-- PARTICAO PELO X
-- --------------------------
--medio :: xs -> Int
medio as = xcoord (pega as (metade as)) -- Corte pela coordenada "X" 

--media :: xs -> Int
media bs = ycoord (pega bs (metade bs)) -- Corte pela coordenada "Y"

pega as b = head ((drop (b-1) (take b as)))

metade as = (div (length as) 2)

esq as = take (metade as) as  

dir as = drop (metade as) as

-- --------------------------
-- QUICK-SORT
-- --------------------------
qs [] = []
qs ((a,b):x) = (qs (split (<) (a,b) x) ++ ((a,b):qs (split (>) (a,b) x)))

split op a [] = []
split op a (b:x) = if op a b 
                    then b:(split op a x)
                   else (split op a x)
		   
		   
-- #############################
-- EXERCICIO 2 (isKDtree)
-- #############################
 --isKDtree :: Ord a => (Kdtree a) -> Bool
isKDtree (Node bool int xs ys) = if bool == True 
				    then isTrue (verifLeft xs ++ verifRight ys)
				 else False

				 
isTrue cx = if [ y | y <-cx , y == False] == []
		then True
	    else False
				 
verifLeft (Leaf a) = [True]
verifLeft (Node b i as bs)  =  if b == False
			            then [True] ++ noX as ++ noX bs
			         else [False]

noX (Leaf a) = [True]
noX (Node bo it ax bx) = if  bo == True
					    then [True] ++ verifLeft ax ++ verifLeft bx
					 else [False]

verifRight (Leaf a) = [True]
verifRight (Node b i as bs)  =  if b == False
			            then [True] ++ noY as ++ noY bs
			         else [False]

noY (Leaf a) = [True]
noY (Node bo it ax bx) = if  bo == True
					    then [True] ++ verifRight ax ++ verifRight bx
					 else [False]

				
-- ---------------------
-- Pontos de teste
-- ---------------------
pontos = [(6734,1453),(2233,10),(5530,1424),(401,841),(3082,1644),(7608,4458),(7573,3716),(7265,1268),(6898,1885),(1112,2049),(5468,2606),(5989,2873),(4706,2674),(4612,2035),(6347,2683),(6107,669),(7611,5184),(7462,3590),(7732,4723),(5900,3561),(4483,3369),(6101,1110),(5199,2182),(1633,2809),(4307,2322),(675,1006),(7555,4819),(7541,3981),(3177,756),(7352,4506),(7545,2801),(3245,3305),(6426,3173),(4608,1198),(23,2216),(7248,3779),(7762,4595),(7392,2244),(3484,2829),(6271,2135),(4985,140),(1916,1569),(7280,4899),(7509,3239),(10,2676),(6807,2993),(5185,3258),(3023,1942)]
pontos2 = [(1380,939),(2848,96),(3510,1671),(457,334),(3888,666),(984,965),(2721,1482),(1286,525),(2716,1432),(738,1325),(1251,1832),(2728,1698),(3815,169),(3683,1533),(1247,1945),(123,862),(1234,1946),(252,1240),(612,673),(2576,1676),(928,1700),(53,857),(1807,1711),(274,1420),(2574,946),(178,24),(2678,1825),(1795,962),(3384,1498),(3520,1079),(1256,61),(1424,1728 ),(3913,192),(3085,1528),(2573,1969),(463,1670),(3875,598),(298,1513),(3479,821),(2542,236),(3955,1743),(1323,280),(3447,1830),(2936,337),(1621,1830),(3373,1646),(1393,1368),(3874,1318),(938,955),(3022,474),(2482,1183),(3854,923),(376,825),(2519,135),(2945,1622),(953,268),(2628,1479),(2097,981),(890,1846),(2139,1806),(2421,1007),(2290,1810),(1115,1052),(2588,302),(327,265),(241,341),(1917,687),(2991,792),(2573,599),(19,674),(3912,1673),(872,1559),(2864,558),(928,1766),(838,620),(3893,103),(2179,1619),(3822,899),(379,1048),(1179,100),(2599,902),(3417,143),(2961,1605),(612,1384),(3113,886),(2597,1830),(2587,1286),(162,906),(1428,134),(742,1025),(1626,1651),(1187,500),(1788,1009),(23,987),(3641,43),(3756,883),(777,392),(1725,1642),(199,1810),(3951,1558),(6734,1453),(1189,402),(5530,1424),(401,841),(3082,1644),(7608,4458),(7573,3716),(7265,1268),(6898,1885),(1112,2049),(5468,2606),(5989,2873),(4706,2674),(4612,2035),(6347,2683),(6107,669),(7611,5184),(7462,3590),(7732,4723),(5900,3561),(4483,3369),(6101,1110),(5199,2182),(1633,2809),(4307,2322),(675,1006),(7555,4819),(7541,3981),(3177,756),(7352,4506),(7545,2801),(3245,3305),(6426,3173),(4608,1198),(23,2216),(7248,3779),(7762,4595),(3484,2829),(6271,2135),(4985,140),(1916,1569),(7280,4899),(7509,3239),(10,2676),(6807,2993),(5185,3258),(3023,1942),(3911,1673),(2863,558),(929,1766),(839,620),(3893,102),(2178,1619),(378,1048),(1178,100),(2599,901),(3416,143),(611,1384),(3113,885),(2586,1286),(161,906),(1429,134),(1625,1651),(1188,506),(1787,1009),(22,987),(3640,43),(3756,882)]
pontos280 = [(288,149),(288,129),(270,133),(256,141),(256,157),(246,157),(236,169),(228,169),(228,161),(220,169),(212,169),(204,169),(196,169),(188,169),(196,161),(188,145),(172,145),(164,145),(156,145),(148,145),(140,145),(148,169),(164,169),(172,169),(156,169),(140,169),(132,169),(124,169),(116,161),(104,153),(104,161),(104,169),(90,165),(80,157),(64,157),(64,165),(56,169),(56,161),(56,153),(56,145),(56,137),(56,129),(56,121),(40,121),(40,129),(40,137),(40,145),(40,153),(40,161),(40,169),(32,169),(32,161),(32,153),(32,145),(32,137),(32,129),(32,121),(32,113),(40,113),(56,113),(56,105),(48,99),(40,99),(32,97),(32,89),(24,89),(16,97),(16,109),(8,109),(8,97),(8,89),(8,81),(8,73),(8,65),(8,57),(16,57),(8,49),(8,41),(24,45),(32,41),(32,49),(32,57),(32,65),(32,73),(32,81),(40,83),(40,73),(40,63),(40,51),(44,43),(44,35),(44,27),(32,25),(24,25),(16,25),(16,17),(24,17),(32,17),(44,11),(56,9),(56,17),(56,25),(56,33),(56,41),(64,41),(72,41),(72,49),(56,49),(48,51),(56,57),(56,65),(48,63),(48,73),(56,73),(56,81),(48,83),(56,89),(56,97),(104,97),(104,105),(104,113),(104,121),(104,129),(104,137),(104,145),(116,145),(124,145),(132,145),(132,137),(140,137),(148,137),(156,137),(164,137),(172,125),(172,117),(172,109),(172,101),(172,93),(172,85),(180,85),(180,77),(180,69),(180,61),(180,53),(172,53),(172,61),(172,69),(172,77),(164,81),(148,85),(124,85),(124,93),(124,109),(124,125),(124,117),(124,101),(104,89),(104,81),(104,73),(104,65),(104,49),(104,41),(104,33),(104,25),(104,17),(92,9),(80,9),(72,9),(64,21),(72,25),(80,25),(80,41),(88,49),(104,57),(124,69),(124,77),(132,81),(140,65),(132,61),(124,61),(124,53),(124,45),(124,37),(124,29),(132,21),(124,21),(120,9),(128,9),(136,9),(148,9),(162,9),(156,25),(172,21),(180,21),(180,29),(172,29),(172,37),(172,45),(180,45),(180,37),(188,41),(196,49),(204,57),(212,65),(220,73),(228,69),(228,77),(236,77),(236,69),(236,61),(228,61),(228,53),(236,53),(236,45),(228,45),(228,37),(236,37),(236,29),(228,29),(228,21),(236,21),(252,21),(260,29),(260,37),(260,45),(260,53),(260,61),(260,69),(260,77),(276,77),(276,69),(276,61),(276,53),(284,53),(284,61),(284,69),(284,77),(284,85),(284,93),(284,101),(288,109),(280,109),(276,101),(276,93),(276,85),(268,97),(260,109),(252,101),(260,93),(260,85),(236,85),(228,85),(228,93),(236,93),(236,101),(228,101),(228,109),(228,117),(228,125),(220,125),(212,117),(204,109),(196,101),(188,93),(180,93),(180,101),(180,109),(180,117),(180,125),(196,145),(204,145),(212,145),(220,145),(228,145),(236,145),(246,141),(252,125),(260,129),(280,133)]


peso (a:[]) = 0  
peso (a:xs) = dista a (head xs) + peso xs

dista p q = ((ycoord q - ycoord p)^2 + (xcoord q - xcoord p)^2)
