-- #############################
-- EXERCICIO 11 (Greedy)
-- #############################
module Greedy where
import KDtree
import NN
import Point

-- greedy :: Ord a => [Point a] -> [Point a]
greedy [] = []
greedy xs = let as = (pesoAr (achaArestas (head xs) (tail xs)))
		 in (noRepet (findWay (head as) (as!!1) ++ (greedyTour  (delNo (xcoord (head as)) as))))

-- Funcao que retorna o melhor ponto para que o tour seja iniciado
findWay p ed = if findX (xcoord p) ed
		  then [(ycoord p)] ++ [(xcoord p)]
	       else if findY (ycoord p) ed
	               then [(xcoord p)] ++ [(ycoord p)]
		    else [(xcoord p)] ++ [(ycoord p)]

-- Funcao que retorna a lista de hastes tirando a haste que tem grau 2
delNo e [] = []
delNo e fd = [head fd] ++ [ z | z <-[ y | y <-(tail fd), (xcoord y) /= e], (ycoord z) /= e]

achaArestas a [] = []
achaArestas a ys = if length ys == 1
         		      then zip [a] ys
                   else [ (a,y) | y <-ys] ++ achaArestas (head ys) (tail ys)

-- Funcao que estabelesse um "grau" inicial para os pontos
grauAr [] = [] 
grauAr ar = (zip [(xcoord (head ar))] (zip (zip [(xcoord (ycoord (head ar)))] [0]) (zip [(ycoord (ycoord (head ar)))] [0]))) ++ grauAr (tail ar)

-- Funcao que coloca um "peso" ou "custo" em cada aresta possivel
pesoAr [] = []
pesoAr xs = [ (ycoord z) | z <-(reverse (qs ([ (distAr (xcoord y) (ycoord y), y) | y <-xs] )))]

-- Funcao qeu retorna o Tour dado as hastes em ordem
greedyTour [] = []
greedyTour ax = if (length ax /= 1)
                   then   if findX (ycoord (head ax)) (ax!!1)
	                         then [ycoord (ax!!1)] ++ greedyTour (zip [(xcoord (ax!!1))] [(ycoord (ax!!1))] ++ (delNo (ycoord (head ax)) (drop 2 ax)))
                          else if findY (ycoord (head ax)) (ax!!1)
                                  then [xcoord (ax!!1)] ++ greedyTour (zip [(ycoord (ax!!1))] [(xcoord (ax!!1))] ++ (delNo (ycoord (head ax)) (drop 2 ax)))
                               else [xcoord (ax!!1)] ++ [ycoord (ax!!1)] ++ greedyTour ([ax!!1] ++ (delNo (ycoord (head ax)) (delNo (xcoord (ax!!1)) (drop 2 ax))))
                 else [xcoord(head ax)] ++ [ycoord(head ax)]

-- Funcao que encontra um ponto em uma aresta na parte de xcoord
findX a b = if a == (xcoord b)
                then True
              else False
-- Funcao que encontra um ponto em uma aresta na parte de ycoord
findY a b = if a == (ycoord b)
                then True
              else False

-- Funcao que deleta a haste que ja foi usada, eliminando assim o calculo de grau dos pontos
delAr a [] = []
delAr a ds = [ y | y <- ds, a /= y]

-- Funcao que retorna a distancia entre duas arestas
distAr p q = ((ycoord q - ycoord p)^2 + (xcoord q - xcoord p)^2)

-- Funcao que retorna uma lista sem repetição
noRepet [] = []
noRepet ds = [head ds] ++ noRepet (del (head ds) (tail ds))

mergeTree (Leaf a) = [] ++ a
mergeTree (Node bool i xs ys) = mergeTree xs ++ mergeTree ys


-- #############################
-- EXERCICIO 13
-- #############################
-- delete :: Ord a => Point a -> (KDtree a ) -> (KDtree a)
delete a (Node bool int xs ys) = build (del a (mergeTree (Node bool int xs ys)))

-- nn :: (Point a) -> (KDtree a) -> (Point a)

nnKDtree a (Node bool int xs ys) = func2 (func a (mergeTree (Node bool int xs ys))) (mergeTree (Node bool int xs ys))
