-- *****************************************************
-- *********************PqGreedy************************
-- *****************************************************
-- Exercício 14 --
module Pqgreedy where

import Point
import Greedy
import KDTree

pqgreedy	:: (Ord a,Num a) => [Point a] -> [Point a]
pqgreedy xs	= let
		arvore = build xs
		in init_greedy_tour2 arvore (quick_edge (lista_edge arvore xs))

init_greedy_tour2 kd ((a,b,c):xs) = greedy_tour2 kd xs [[a,b]]

greedy_tour2	:: (Ord a,Num a) => (KDtree a) -> [Edge a] -> [[Point a]] -> [Point a]

greedy_tour2 kd [] ys = head ys
greedy_tour2 kd ((a,b,c):xs) ys	= let
				v_a = verifica_grau ys a
				v_b = verifica_grau ys b
				in if (v_a == 0)
				then	if (v_b == 0)
					then greedy_tour2 kd xs (ys++[[a,b]])
					else	if (v_b == 1)
						then greedy_tour2 (delete b kd) xs (ins_edge_1_0 ys (b,a))
						else greedy_tour2 kd (new_edge kd xs a) ys
				else	if (v_a == 1)
					then	if (v_b == 0)
						then greedy_tour2 (delete a kd) xs (ins_edge_1_0 ys (a,b))
						else	if (v_b == 1)
							then let 
								atual_1_1	= ins_edge_1_1 ys (a,b)
								in if (atual_1_1 == ys)
								then greedy_tour2 kd (new_edge (delete b kd) xs a) ys
								else greedy_tour2 (delete b (delete a kd)) xs atual_1_1
							else greedy_tour2 kd (new_edge kd xs a) ys
					else	if (v_b == 0)
						then greedy_tour2 kd (new_edge kd xs b) ys
						else	if (v_b == 1)
							then greedy_tour2 kd (new_edge kd xs b) ys
							else greedy_tour2 kd (new_edge kd xs a) ys

lista_edge _ []		= []
lista_edge kd (a:xs)	= (cria_edge a p_edge):(lista_edge kd xs)
			where 
			p_edge = (nnK a kd)

new_edge kd [] a	= []
new_edge kd xs a	= let 
			  vizin =  nnK a kd
			 in
			 insert_ord  (cria_edge a vizin) xs
