-- **********************************************************************
-- *****************Arvore Binaria de Prioridade*************************
-- **********************************************************************
-- Exercicio 4

module Binpq where

data Binpq a =   Null
	       | Node (Binpq a) a (Binpq a) 
	       deriving Show 
	       
merge :: Ord a =>Binpq a -> Binpq a -> Binpq a

merge Null  y  = y
merge x     Null = x 
merge (Node x a y) (Node u b v)
	  | a < b 	 = Node  (merge y (Node u b v )) a x  
	  | a >= b       = Node  (merge (Node x a y) v ) b u


insert :: Ord a => Binpq a -> a -> Binpq a 	 

insert Null a = Node (Null) a (Null) 
insert (Node x a y ) b 
		 	| a < b     = Node (insert x b) a y
			| a == b    = Node x a y 
			| a > b     = Node x b (insert y a)
			
mini :: Binpq a ->  a

mini (Node x a y) = a

delmin ::  Ord a =>Binpq a -> Binpq a

delmin Null = Null
delmin (Node x a y ) = merge x y

-- Exercicio 5 

isBinpq :: Ord a => Binpq a -> Bool 

data Verific_Binpq a =	  Is_binpq a
			| Not_binpq a
			deriving (Eq,Read,Show) 

isBinpq Null = True
isBinpq t@(Node x a y) =  case (verif t) of 
			(Is_binpq a ) -> True
			(Not_binpq a) -> False

verif (Node Null a Null) = Is_binpq a	
verif (Node Null a y )	= case (verif y ) of
				 ( Is_binpq b) ->if (a<=b) 
				 		then (Is_binpq a)	
						else (Not_binpq a)
				 ( Not_binpq b)-> (Not_binpq a) 
				 
verif (Node x a Null )	= case (verif x ) of
				 ( Is_binpq b) -> if (a<=b) 
				 		then (Is_binpq a)
						else (Not_binpq a)	
				 ( Not_binpq b)->(Not_binpq a) 
				 	 
verif (Node x a y) 	= case ( verif x ) of 
				( Is_binpq b ) -> case ( verif y ) of
						 (Is_binpq c) -> if ( (b >= a)&&(c >= a) )
								then (Is_binpq a)
								else (Not_binpq a)
						 (Not_binpq c) -> (Not_binpq c)
				(Not_binpq b) -> (Not_binpq b)					 
