-- *********************************************************
-- ***********Arvore Binaria Espacial KDtree ***************
-- *********************************************************
-- Exercicio 1 

module KDTree where

import Point

data KDtree a =  Null  
		| Leaf [Point a]
		| Node Bool a (KDtree a) (KDtree a) 
		deriving Show


build :: (Ord a,Num a,Show a) => [Point a] -> KDtree a

build xs = aux True xs


-- Retorna a coordenada X ou Y do ponto 
param bool a 
	    | bool 	   = (fst a) 
	    | otherwise    = (snd a)

-- Retorna uma dupla com o menor e o maior elemento da lista (X ou Y)
part bool a []= a
part bool (x,y) (a:xs) 	
			| coord_a <= x = part bool (coord_a, y) xs
			| coord_a >= y = part bool (x, coord_a) xs
			| otherwise = part bool (x,y) xs
			where 
			coord_a = param bool a		

-- Encontra a coordenada central 		
meio bool xs =  div (( fst part_xs )+ (snd part_xs) ) 2 
		where 
		coord_a = param bool (head xs)
		part_xs = part bool (coord_a, coord_a) xs

--Separa a lista de acordo com a linha de particionamento 
separa bool op [] a = []
separa bool op xs a 
		    | bool 	 =  [(x,y)|(x,y)<-xs, op x  a ]
		    | otherwise  =  [(x,y)|(x,y)<-xs, op y  a ]

-- Funcao auxiliar que constroi a arvore 
aux bool [ ] = Null
aux bool xs  
		| (length xs <= 8)	= Leaf xs 
   		| otherwise		= let 
					center = get_meio bool xs
					in Node bool (center)
		  			( aux (not bool) (separa bool (<=) xs (center) ))
		  			( aux (not bool) (separa bool (>)  xs (center) ))

-- Função que acha a coordenada do meio sem precisar ordenar a lista
get_meio bool []	= (-1)
get_meio bool (a:xs)	= is_meio bool (insere_meio bool (a:xs)) a 0 (div (length (a:xs)) 2)

is_meio bool [a] _ _ _	= select bool a
is_meio bool xs a l t	= if bool
			then	let
				x = l + (length (takeWhile (verify bool (<) a) xs))
				in if (x == t)
				then (fst a)
				else	if (x < t)
					then let
						ys = tail (dropWhile (verify bool (<) a) xs)
						in is_meio bool (insere_meio bool ys) (head ys) (x+1) t
					else let
						zs = takeWhile (verify bool (<) a) xs
						in is_meio bool (insere_meio bool zs) (head zs) l t
			else	let
				x = l + (length (takeWhile (verify bool (<) a) xs))
				in if (x == t)
				then (snd a)
				else	if (x < t)
					then let 
						ys = tail (dropWhile (verify bool (<) a) xs)
						in is_meio bool (insere_meio bool ys) (head ys) (x+1) t
					else let 
						zs = takeWhile (verify bool (<) a) xs
						in is_meio bool (insere_meio bool zs) (head zs) l t

verify bool op a b	| bool		= op (fst b) (fst a)
		 	| otherwise	= op (snd b) (snd a)

insere_meio bool []	= []
insere_meio bool (a:xs)	= ((separa bool (<) xs (select bool a)) ++ (a:(separa bool (>=) xs (select bool a))))

select bool a	| bool		= fst a
		| otherwise	= snd a

--Exercicio 2

data Treeconcat a =	Tconcat a
		|	Notconcat a
	deriving (Eq,Read,Show)
	
isKDtree :: Ord a => KDtree a -> Bool

isKDtree Null = True
isKDtree (Leaf xs) = True
isKDtree t@(Node bool a x y) = case (desce t) of
				(Tconcat xs) -> True
				(Notconcat []) -> False

-- Funcao q desce na arvore e retorna Tconcat ao encontrar uma folha, se a lista estiver correta 
-- (de acordo com o particionamento) vai se concatenar com a lista da folha ao lado e chamar novamente 
-- a funcao, senao retorna Notconcat  
desce Null = Tconcat []
desce (Leaf a) = Tconcat a			  
desce (Node bool a x y) = case (desce x) of
			(Tconcat ax) -> if (verifica bool (<=) ax a )
					then case (desce y) of
						(Tconcat bx) -> if (verifica bool (>) bx a )
								then Tconcat (ax ++ bx)
								else Notconcat []
						(Notconcat []) -> Notconcat []
					else Notconcat []
			(Notconcat []) -> Notconcat []

-- Verifica se os elementos da lista estao obedecendo o particionamento
verifica bool op [] a = True
verifica bool op (b:xs) a 
		| op  (param bool b) a 	= (verifica bool op xs a )
		| otherwise  		= False 

   
-- **********************************************************************
-- ********************Arvore Espacial semi-dinamica ********************
-- **********************************************************************
-- Exercicio 13

delete	:: (Ord a, Num a) => (Point a) -> (KDtree a) -> (KDtree a)

delete a Null = Null
delete a ( Leaf [b]) =	if (a == b)
			then Null
			else Leaf [b]
delete a ( Leaf xs ) = Leaf ( del a xs )
delete a (Node bool b x y ) 
			 |(param bool a )<= b	= Node bool b (delete a x ) y
			 | otherwise 		= Node bool b x (delete a y)   
			 
dell a [] = [] 
dell a (b:xs) 
	    | a == b	= xs 
	    | otherwise = (b:(dell a xs))  

getmenor2 [a] = a
getmenor2 (a:xs) 
		| ( (snd a) < ( snd (head xs) )) = getmenor2 (a:(tail xs))
		| otherwise   = getmenor2 xs

data Vizinh a =   Isvizin a 
		| Notvizin a 		
		deriving (Eq,Read,Show)

nnK	:: (Ord a, Num a) => (Point a) -> (KDtree a) -> (Point a)

nnK a tree = case (vizin2 a tree) of 
		   (Isvizin b ) -> ( fst b)
		   (Notvizin b) -> ( fst b)
 			
verific_part dist part point bool  = if ( (distancia (part_x_y bool point part) point ) < dist)
				    then True
				    else False
			  
			   
part_x_y bool a b 
		| bool = (b, snd a) 
		| otherwise = (fst a , b)


auxvizin a Null = Notvizin (a, 0)
auxvizin a ( Leaf [b] )	| a == b	= Notvizin (a,0)
			| otherwise	= Isvizin  (b,(distancia a b))
				
auxvizin a ( Leaf xs ) = Isvizin (getmenor2 ( calc_dist xs a ))
auxvizin a ( Node bool b x y) = if ( (param bool a ) <= b )
				then case (auxvizin a x ) of 
					  (Isvizin c )-> case ( auxvizin  a y ) of 
							  	(Isvizin d)-> if( (snd c) <= (snd d))
										then Isvizin c
										else Isvizin d
								(Notvizin d)-> (Isvizin c)

					  (Notvizin c)-> case (auxvizin  a y) of
								(Isvizin d)->(Isvizin d)
								(Notvizin d)->(Notvizin d)
				else case (auxvizin  a y) of
					  (Isvizin c )-> case ( auxvizin  a x ) of 
							  	(Isvizin d)-> if( (snd c) <= (snd d))
										then (Isvizin c)
										else (Isvizin d)  
								(Notvizin d)-> (Isvizin c)

					  (Notvizin c)-> case ( auxvizin a x) of
								(Isvizin d)->(Isvizin d)
								(Notvizin d)->(Notvizin d)

vizin2 a Null = Notvizin (a, 0)
vizin2 a ( Leaf [b] )	| a == b	= Notvizin (a,0)
			| otherwise	= Isvizin  (b,(distancia a b))
				
vizin2 a ( Leaf xs ) = Isvizin (getmenor2 ( calc_dist xs a ))
vizin2 a ( Node bool b x y) = if ( (param bool a ) <= b )
				then case (vizin2 a x ) of 
					  (Isvizin c )-> if ( verific_part (snd c) b a bool )
					  		  then  case ( auxvizin a y ) of 
							  	(Isvizin d)-> if( (snd c) <= (snd d))
										then Isvizin c
										else Isvizin d
								(Notvizin d)-> (Isvizin c)
							  else (Isvizin c)
					  (Notvizin c)-> case(vizin2 a y) of
								(Isvizin d)->(Isvizin d)
								(Notvizin d)->(Notvizin d)
				else case (vizin2 a y) of
					  (Isvizin c )-> if ( verific_part (snd c) b a bool )
					  		  then  case ( auxvizin a x ) of 
							  	(Isvizin d)-> if( (snd c) <= (snd d))
										then Isvizin c
										else Isvizin d
								(Notvizin d)-> (Isvizin c)
							  else (Isvizin c)
					  (Notvizin c)-> case (vizin2 a x) of
								(Isvizin d)->(Isvizin d)
								(Notvizin d)->(Notvizin d)
