-- *************************************************************
-- *********************Greedy**********************************
-- *************************************************************
-- Exercicio 11 
module Greedy where

import Point

greedy	:: (Ord a,Num a) => [Point a] -> [Point a]

greedy []	= []
greedy xs	= let
		edges = lista_edge1 xs
		in
		init_greedy_tour (quick_edge edges)

insert_ord	:: (Ord a) => (Edge a) -> [Edge a] -> [Edge a]
insert_ord a [] = [a]
insert_ord t@(x,y,z) v@((a,b,c):xs) 	| z <= c	= (t:v)
					| otherwise	= ((a,b,c):(insert_ord t xs))

verifica_grau	:: (Eq a,Ord a,Num a) => [[Point a]] -> Point a -> a
verifica_grau [] b		= 0
verifica_grau ((a:xs):ys) b	| a == b		= 1
				| (last xs) == b	= 1
				| nalista (init xs) b	= 2
				| otherwise		= (verifica_grau ys b)

nalista [] _		= False
nalista (a:xs) b	| a == b	= True
			| otherwise	= (nalista xs b)

init_greedy_tour ((a,b,c):ys)	= greedy_tour ys [[a,b]]

greedy_tour [] ys		= (head ys)
greedy_tour ((a,b,c):ys) zs	= let
				verifica_a	= verifica_grau zs a
				verifica_b	= verifica_grau zs b
				in if (verifica_a == 0)
				then	if (verifica_b == 0)
					then greedy_tour ys (zs++[[a,b]])
					else	if (verifica_b == 1)
						then greedy_tour ys (ins_edge_1_0 zs (b,a))
						else greedy_tour ys zs
				else	if (verifica_a == 1)
					then	if (verifica_b == 0)
						then greedy_tour ys (ins_edge_1_0 zs (a,b))
						else	if (verifica_b == 1)
							then	let 
								atual_1_1	= ins_edge_1_1 zs (a,b)
								in if (atual_1_1 == zs)
								then greedy_tour ys zs
								else greedy_tour ys atual_1_1
							else greedy_tour ys zs
					else	greedy_tour ys zs

quick_edge [] = []
quick_edge ((a,b,c):x) = (quick_edge (split_edge (<) c x) ++ ((a,b,c):(quick_edge (split_edge (>=) c x))))

split_edge op a [] = []
split_edge op a ((b,c,d):x)	= if op d a
				then (b,c,d) : (split_edge op a x)
				else (split_edge op a x)

lista_edge1 []		= []
lista_edge1 (a:xs) 	= (map (cria_edge a) xs)++(lista_edge1 xs)

cria_edge a b		= (a,b,distancia a b)

ins_edge_1_0 [] _		= []
ins_edge_1_0 ((a:xs):ys) (b,c)	| b == a		= ((c:(a:xs)):ys)
				| b == (last xs)	= (((a:xs)++[c]):ys)
				| otherwise		= ((a:xs):(ins_edge_1_0 ys (b,c)))

ins_edge_1_1	:: (Ord a,Num a,Eq a) => [[Point a]] -> (Point a, Point a) -> [[Point a]]
ins_edge_1_1 [] _			= []
ins_edge_1_1 t@((a:xs):ys) (b,c)	| (a==b)	= if (c==(last xs))
							then t
							else liga_subtour (a:xs) ys c
					| (a==c)	= if (b==(last xs))
							then t
							else liga_subtour (a:xs) ys b
					| (b==(last xs))	= liga_subtour (invert (a:xs)) ys c
					| (c==(last xs))	= liga_subtour (invert (a:xs)) ys b
					| otherwise		= ((a:xs):(ins_edge_1_1 ys (b,c)))

liga_subtour [] ys _		= []
liga_subtour xs [] _		= []
liga_subtour xs (b:ys) c	| c == (head b)	= (((invert xs)++b):ys)
				| c == (last b) = ((b++xs):ys)
				| otherwise	= (b:(liga_subtour xs ys c))
