-- ***************** Heuristica FRP*********************
module Frp where

import Point
import Nn
import KDTree

--Exercicio 9 
frp :: (Ord a,Num a) => [Point a] -> [Point a]
frp [] =[]
frp xs = faztour (build xs)

faztour Null = []
faztour ( Leaf xs ) = nn xs
faztour ( Node bool a x y ) = merge_tour bool (faztour x ) ( faztour y )

merge_tour bool  [] y = y
merge_tour bool  x [] = x
merge_tour bool  x y	
			|dist_pontas x y == 0 = y ++ x
			|dist_pontas x y == 1 = x ++ (invert y)
			|dist_pontas x y == 2 = x ++ y
			|dist_pontas x y == 3 = (invert x) ++ y

dist_pontas x y = if (distancia (head x) (last y) < distancia (head x) (head y))
		then if (distancia (head x) (last y) < distancia (last x) (head y))
			then if (distancia (head x) (last y) < distancia (last x) (last y))
				then 0
				else 1
			else if (distancia (last x) (head y) < distancia (last x) (last y))
				then 2
				else 1
		else if (distancia (head x) (head y) < distancia (last x) (head y))
			then if (distancia (head x) (head y) < distancia (last x) (last y))
				then 3
				else 1
			else if (distancia (last x) (head y) < distancia (last x) (last y))
				then 2
				else 1

take_pts a xs = (takeWhile (/= a) xs)++[a]
drop_pts a xs = tail (dropWhile (/= a) xs)
drop_pts2 a xs = (dropWhile (/= a) xs)
