module TourEval where

import Data.Array
import Data.Maybe
import Data.List(takeWhile,dropWhile,sortBy,maximumBy)
import Point 
import BTree

import Debug.Trace
import Control.Exception


toureval pts = 	let
		 tour = fi pts
		in assert ((length tour) == (length pts)) tour

fi pts = let 
           allnn = allnnEval pts
           start = startTour allnn
	   nontour = nonTour pts start
         in fiIter (assert (startTourOK start pts) start) 
                   allnn 
                   nontour 


fiIter tour _ Leaf = tour
fiIter tour allnn nontourpq = 
	let Just ((dtour,tourpt,ntourpt),nnontourpq) = splitMax nontourpq
            nearTN = nearestTourNeighbor ntourpt tour allnn 
        in if nearTN == tourpt
           then fiIter (tourInsert ntourpt tourpt tour) allnn nnontourpq
	   else fiIter tour allnn (nonTourpqUpdate nearTN ntourpt nnontourpq)


-- evaluate all nearest neighbors
--allnnEval pts = map (\pt -> (pt,sortBy (distsrc pt) [np | np <- pts, np/=pt])) 
--                    pts
allnnEval pts = map (\pt -> (pt,tail (sortBy (distsrc pt) [np | np <- pts])))
                    pts
  

allnnOK allnn = all (\ (pt,nn) -> (length allnn) ==  ((length nn)+1)) allnn

distsrc pt pt0 pt1 = distcmp (pt,pt0) (pt,pt1)
 
-- compare pairs of points wrt squared distance
distcmp pp0 pp1 =
	let 
 	  dpp0 = sqrdist pp0
          dpp1 = sqrdist pp1
	in if dpp0 < dpp1 then LT
	   else if dpp0 == dpp1 then EQ
	   else GT


---------------- start tour  -----------------
startTour allnn = 
	let (pt0,pt1) = maximumBy distcmp (map (\(pt,nn) -> (pt,last nn)) allnn)
	in [pt0,pt1]

startTourOK [pt0,pt1] pts = all (\ pt -> sqrdist (pt1,pt0) >= sqrdist (pt,pt0)
                                         && sqrdist(pt1,pt0) >= sqrdist(pt,pt1))
                                pts

-- nearest tour neighbor finding

nearestTourNeighbor ntp tour allnn = 
	let 
	  (Just nn) = lookup ntp allnn
	in head (filter (\pt -> elem pt tour) nn)


--  tour insertion

tourInsert nTpt pt tour = 
	let tb = tourInsertBefore nTpt pt tour
            ta = tourInsertAfter nTpt pt tour
	in if (tourWeight tb) <= (tourWeight ta)
	   then assert ((length tb) == (length tour)+1) tb
	   else assert ((length ta) == (length tour)+1) ta 


tourInsertBefore nTpt pt tour = (takeWhile (/=pt) tour)++
			 	(nTpt:(dropWhile (/=pt) tour))

tourInsertAfter nTpt pt tour = 
	let frpt = dropWhile (/= pt) tour
	in (takeWhile (/=pt) tour)++((head frpt):nTpt:(tail frpt))


------ tour weight

tourWeight :: [Point Int]->Int
tourWeight tour = foldl (+) 0  (map sqrdist (zip (tour++[(head tour)]) 
                                               (tail (tour++[(head tour)]))))

-- nontour priority queue
nonTour pts [pt0,pt1] = btreeFoldr (map (tourNeighbor pt0 pt1) 
			                (filter (\pt -> pt/= pt0 && pt/= pt1)
						pts))

tourNeighbor pt0 pt1 pt =
	let
	   ptpt0 = sqrdist (pt0,pt) 
           ptpt1 = sqrdist (pt1,pt) 
        in if ptpt0 < ptpt1
           then (ptpt0,pt0,pt)
           else (ptpt1,pt1,pt)


nonTourpqUpdate tourpt nTourpt pq = 
	insert pq (sqrdist (tourpt,nTourpt),tourpt,nTourpt) 


