module Main where

-- next line imports module Point
import Point

-- program execution starts by calling function main, defined next

{-                                  main  
   'main' does
          calls 'readIntpts' to read a list of  (point Int)
          calls 'alldists' to evaluate the square of the distance between
                           every pair of points in the list received from
                           readIntPts
          calls putStrLn to output the list of distances
-}

main = readIntPts [] >>= \ls -> putStrLn (show (alldists ls))

alldists :: [Point Int] -> [Integer]
alldists xs = map (truncate . sqrdist) (zip xs (tail xs))

--sqrdist :: (Point Int, Point Int) -> Int
--sqrdist ((x0,y0), (x1,y1)) = (x0-x1)^2+(y0-y1)^2
