(defun insert (a x) 
  (cond ((null x) (cons a x))
	((<= a (car x)) (cons a x))
	(t (cons (car x) (insert a (cdr x))))))

(defun insSort (x)
  (if (null x) x
    (insert (car x) (insSort (cdr x)))))

(deftype intlist () '(or null (cons fixnum)))

(defun rinsSort (x)
  (reduce #'(lambda (x a) (insert a x)) x :initial-value '()))

(locally
  (declare (optimize (speed 3); ))
		     (safety 0)))
  (defun part (a x y z)
    (declare (type fixnum a)
	     (type intlist x) 
	     (type intlist y)
	     (type intlist z))
    (cond ((null x) (list y z))
	  ((<= (car x) a) (part a (cdr x) (cons (car x) y) z))
	  (t (part a (cdr x) y (cons (car x) z))))) 

  (defun npart (a x)
    (declare (type fixnum a) 
	     (type intlist x))
    (do ((y '())
	 (z '()))
      ((null x) (list y z))
      (if (<= (car x) a)  
	(push (car x) y)
	(push (car x) z))
      (pop x)))

  (defun qsort (x)
    (declare (type intlist x))
    (if (null x) x
      (let ((p (part (car x) (cdr x) '() '())))
	(append (qsort (car p)) (cons (car x) (qsort (cadr p)))))))

  (defun qsort1 (x)
    (declare (type intlist x))
    (if (null x) x
      (let ((p (npart (car x) (cdr x))))
	(append (qsort (car p)) (cons (car x) (qsort (cadr p)))))))


  (defun nqsort (x)
    (declare (type intlist x))
    (if (null x) x
      (let ((p (part (car x) (cdr x) '() '())))
	(nconc (qsort (car p)) (cons (car x) (qsort (cadr p)))))))

 
  (defun lomut(v l u) 
    (declare  (type (simple-array fixnum (5000000)) v)
	     (type fixnum l)
	     (type fixnum u))
    (let ((i (1+ l))
	  (pivot (elt v l))
	  (n (1- u)))
      (loop for j from (1+ l) to n
	    do (when (<= (elt v j) pivot)
		 (psetf (elt v i) (elt v j)
			(elt v j) (elt v i))
		 (incf i)))
      (psetf (elt v (1- i)) (elt v l)
	     (elt v l) (elt v (1- i)))
      (1- i)))

  (defun lqsort (x l u)
    (declare (type (simple-array fixnum (50000000)) x)
	     (type fixnum l)
	     (type fixnum u))
    (when (> (- u l) 1)
      (let ((piv (lomut x l u))) 
	(declare (type fixnum piv))
	(lqsort x l piv)
	(lqsort x (1+ piv) u))))

  (defun alomut(v l u) 
    (declare  (type (simple-array fixnum (50000000)) v)
	     (type fixnum l)
	     (type fixnum u))
    (let ((i (1+ l))
	  (pivot (elt v l))
	  (n (1- u)))
      (loop for j from (1+ l) to n
	    do (when (<= (aref v j) pivot)
		 (psetf (aref v i) (aref v j)
			(aref v j) (aref v i))
		 (incf i)))
      (psetf (aref v (1- i)) (aref v l)
	     (aref v l) (aref v (1- i)))
      (1- i)))

  (defun alqsort (x l u)
    (declare (type (simple-array fixnum (5000000)) x)
	     (type fixnum l)
	     (type fixnum u))
    (when (> (- u l) 1)
      (let ((piv (lomut x l u))) 
	(declare (type fixnum piv))
	(alqsort x l piv)
	(alqsort x (1+ piv) u))))


  (defun vtestsort (sortfun n r)
    (declare (type function sortfun)
	     (type fixnum n)
	     (type fixnum r))
    (let ((v (make-array (list n) :element-type 'fixnum
			 :initial-contents(nrands n r))))
      (time (funcall sortfun v 0 n))
      (ordered v)))

  (defun testsort (sortfun n r)
    (declare (type function sortfun)
	     (type fixnum n)
	     (type fixnum r))
    (let ((l (nrands n r))
	  (sl '()))
      (time (setq sl (funcall sortfun l)))
      (ordered sl)))

  )

(locally
  (declare (optimize (speed 1)
		     (safety 0)))

  (defun vlomut(v l u) 
    (declare (type (vector fixnum) v)
	     (type fixnum l)
	     (type fixnum u))
    (let ((i (1+ l))
	  (pivot (elt v l))
	  (n (1- u)))
      (loop for j from (1+ l) to n
	    do (when (<= (elt v j) pivot)
		 (psetf (elt v i) (elt v j)
			(elt v j) (elt v i))
		 (incf i)))
      (psetf (elt v (1- i)) (elt v l)
	     (elt v l) (elt v (1- i)))
      (cons v (1- i))))

  (defun vlqsort (x l u)
    (declare (type (vector fixnum) x)
	     (type fixnum l)
	     (type fixnum u))
    (when (> (- u l) 1)
      (let ((p (vlomut x l u)))
	(let ((piv (cdr p)))
	  (vlqsort x l piv)
	  (vlqsort x (1+ piv) u)))))

  (defun vvtestsort (sortfun n r)
    (declare (type function sortfun)
	     (type fixnum n)
	     (type fixnum r))
    (let ((v (apply #'vector (nrands n r))))
      (declare (type (vector fixnum) v))
      (time (funcall sortfun v 0 n))
      (ordered v)))

  )


(defun upto (n m)
  (if (<= n m) (cons n (upto (1+ n) m))
    '()))

(defun nrands (n r)
  (block nil
	 (when (zerop n) (return '()))
	 (let ((l (list (random r (make-random-state t)))))
	   (decf n)
	   (loop (when (zerop n) (return l))
		 (push (random r) l)
		 (decf n)))))


(defun ordered (x)
  (every #'<= x (subseq x 1)))


