(defclass state ()
  ((config :initarg :configuration
	   :initform nil
	   :accessor config)
   (parent :initarg :parent
	   :initform nil
	   :accessor parent)
   (transition :initarg :transition
	       :initform nil
	       :accessor transition)))

(defgeneric world->state (world))

(defgeneric state->world (state))

(defgeneric solution (state))

(defgeneric branch (state-problem))


(defgeneric equal? (st0 st1))

(defclass state-problem ()
  ((open-set :initarg :open-set
	    :initform nil
	    :accessor open-set)))

(defgeneric problem-search (state-problem insert))

(defgeneric prune (state-problem statelst))

(defgeneric final? (state-problem))
	
(defgeneric solution (state-problem))



(defmethod problem-search ((jp state-problem) insert)
  (loop
	(when (final? jp) (return (solution jp)))
	(let ((next (prune jp (branch jp)))) 
	  (setf (open-set jp) (funcall insert (open-set jp) next)))))


