% Bruce has a 3-gallon jug and a 5-gallon jug, both empty, and a well.
% Our goal is to have exactly 4 gallons in the 5-gallon jug.  He
% can fill a jug from the well, empty a jug onto the ground, and
% carefully pour water from one jug into the other.
%
% j(m, n) is the state in which the 3-gallon jug contains m gallons,
% and the 5-gallon jug contains n gallons.

% fill the 3-gallon jug
j([_,Y], NXY) :- NXY = [3,Y].
% empty the 3-gallon jug
j([_,Y], NXY) :- NXY = [0, Y].
% fill the 5-gallon jug
j([X,_], NXY) :- NXY = [X, 5].
% empty the 5-gallon jug
j([X,_], NXY) :- NXY = [X,0].

% empty the small jug into the big jug
j([X,Y], NXY) :- XpY is X+Y,  
						NXY = [0, XpY], 
						XpY =< 5.
% small -> big, until full
j([X,Y], NXY) :- XpY is X+Y, 
						XpY > 5, NX is X-(5-Y), 
						NXY = [NX,5].
% empty the big jug into the small jug
j([X,Y], NXY) :- XpY is X+Y, 
						XpY =< 3, 
						NXY = [XpY,0].
% big -> small, until full
j([X,Y], NXY) :- XpY is X+Y, XpY > 3, 
						NY is Y-(3-X), 
						NXY = [3,NY].

delta(B, F, H, [B,F]) :-  j(B,F) , not(member(F, H)).
delta(B, F, H, [B | Z]) :- j(B, F0), 
                     not(member(F0, H)), 
		     delta(F0, F, [F0 | H], Z).


