(defstruct puzzle ;:type vector
  (xpos 0 :type fixnum )
  (dim 0 :type fixnum)
  (puz #() :type puzzle)
  (conf (make-array (list 1024) :element-type 'fixnum :initial-element 0) 
	:type (simple-array fixnum (1024))))

(defun clone (puz) 
  (make-puzzle :xpos (puzzle-xpos puz)
	       :dim (puzzle-dim puz)
		   :par puz
	       :conf (copy-seq (puzzle-conf puz))))

(defun up (puz)
  (if (< (- (puzzle-xpos puz) (puzzle-dim puz)) 0) '()
    (let ((dim (puzzle-dim puz))
		  (pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (- pos dim)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (- pos dim))
	     (elt (puzzle-conf puz) (- pos dim)) (elt (puzzle-conf puz) pos)))))

(defun down (puz)
  (if (>= (+ (puzzle-xpos puz) (puzzle-dim puz)) (expt dim 2)) '()
    (let ((dim (puzzle-dim puz))
		  (pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (+ pos dim)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (+ pos dim))
	     (elt (puzzle-conf puz) (+ pos dim)) (elt (puzzle-conf puz) pos)))))

(defun left (puz)
  (if (zerop (puzzle-xpos puz) (puzzle-dim puz)) '()
    (let ((dim (puzzle-dim puz))
		  (pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (- pos 1)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (- pos 1))
	     (elt (puzzle-conf puz) (- pos 1)) (elt (puzzle-conf puz) pos)))))

(defun right (puz)
  (if (= (1+ (puzzle-xpos puz)) (expt (puzzle-dim puz) 2)) '()
    (let ((dim (puzzle-dim puz))
		  (pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (+ pos 1)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (+ pos 1))
	     (elt (puzzle-conf puz) (+ pos 1)) (elt (puzzle-conf puz) pos)))))

(defun move (puz)
  (mapcar #'(lambda (mv)
	      (funcall mv (clone puz)))
	  (list #'up #'down #'left #'right)))

(defun finalp (puz)
  (loop for i from 0 to (- (expt (puzzle-dim puz)) 2)
	(when (not (= (elt (puzzle-conf puz) i) i)) (return '())))
  (= (elt (puzzle-conf puz) (1- (expt (puzzle-dim puz) 2)))))

(defun search (cat puz)
  (let ((open (list puz)))
	(block 'search-loop
		   (loop 
			 (when (null open) (return '()))
			 (let ((son (car open)))
			   (when (finalp son) (return-from 'search-loop son))
			   (setf open (funcall cat (cdr puz) (move puz))))))))

; finish puzzle with struct
; puzzle with class
; puzzle with list (square struct)

