(defconstant cross -1)
(defconstant root 'root)

(defstruct puzzle ;:type vector
  (xpos 0 :type fixnum )
  (dim 0 :type fixnum)
  (par #(0) :type t)
  (mv  'up :type symbol)
  (conf #(cross) :type vector))

(defparameter puzzle-nil 
	  (make-puzzle :xpos 0 
		       :dim 0 
		       :par #(0) 
		       :mv root 
		       :conf #(0)))

(defun clone (puz) 
  (make-puzzle :xpos (puzzle-xpos puz)
	       :dim (puzzle-dim puz)
	       :par puz
	       :conf (copy-seq (puzzle-conf puz))))

(defun up (puz)
  (if (< (- (puzzle-xpos puz) (puzzle-dim puz)) 0) '()
    (let ((dim (puzzle-dim puz))
		  (pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (- pos dim)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (- pos dim))
	     (elt (puzzle-conf puz) (- pos dim)) (elt (puzzle-conf puz) pos)
		 (puzzle-mv puz) 'up)
	  puz)))

(defun down (puz)
  (if (>= (+ (puzzle-xpos puz) (puzzle-dim puz)) 
	  (expt (puzzle-dim puz) 2)) 
    '()
    (let ((dim (puzzle-dim puz))
		  (pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (+ pos dim)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (+ pos dim))
	     (elt (puzzle-conf puz) (+ pos dim)) (elt (puzzle-conf puz) pos)
		 (puzzle-mv puz) 'down)
	  puz)))

(defun left (puz)
  (if (zerop (rem (puzzle-xpos puz) (puzzle-dim puz))) '()
    (let ((pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (- pos 1)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (- pos 1))
	     (elt (puzzle-conf puz) (- pos 1)) (elt (puzzle-conf puz) pos)
		 (puzzle-mv puz) 'left)
	  puz)))

(defun right (puz)
  (if (zerop (rem  (1+ (puzzle-xpos puz)) (puzzle-dim puz))) '()
    (let ((pos (puzzle-xpos puz)))
      (psetf (puzzle-xpos puz) (+ pos 1)
	     (elt (puzzle-conf puz) pos) (elt (puzzle-conf puz) (+ pos 1))
	     (elt (puzzle-conf puz) (+ pos 1)) (elt (puzzle-conf puz) pos)
		 (puzzle-mv puz) 'right)
	  puz)))

(defun move (puz)
  (mapcar #'(lambda (mv)
	      (funcall mv (clone puz)))
	  (list #'up #'down #'left #'right)))

(defun finalp (puz)
  (and (block loop-test
	      (loop for i from 0 to (- (expt (puzzle-dim puz) 2) 2)
		    do (when (/= (elt (puzzle-conf puz) i) i) 
			 (return-from loop-test nil)))
	      ;(print 'true)
	      (return-from loop-test t))
       (= (elt (puzzle-conf puz) (1- (expt (puzzle-dim puz) 2))) cross)))

(defun puzzle-search (insert prune c)
  (let ((open (list (puzzle-init c)))) 
    (block search-loop
	   (loop (print (length open));(print (puzzle-conf (car open)))
	     (cond ((null open) (return-from search-loop '()))
		   ((finalp (car open)) 
		    ;(print (puzzle-conf (car open)))
		    (return-from search-loop (puzzle-result (car open))))
		   (t (setf open (funcall insert  (cdr open) 
					  (funcall prune (move (car open)))))))))))

(defun puzzle-result (puz)
  (labels ((mvscan(p) (if (eq (puzzle-mv p) root) '() 
			(cons (puzzle-mv p) (mvscan (puzzle-par p))))))
	(nreverse (mvscan puz))))

(defun puzzle-init (c)
  (make-puzzle :xpos (position cross c)
	       :conf (make-array (list (length c)) 
				 :initial-contents c
				 :element-type 'fixnum)
	       :dim (nth-value 0 (truncate (sqrt (length c))))
	       :par puzzle-nil :mv root))

(defun straight-prune (ps)
  (remove-if #'(lambda (p) (or (null p) 
			       (puzzle-rep (puzzle-conf p) (puzzle-par p))))
	     ps))

(defun puzzle-rep (conf p)
  (cond ((eq p puzzle-nil) nil)
		((equalp (puzzle-conf p) conf)  t)
		(t (puzzle-rep conf (puzzle-par p)))))


(defun puzzle-gen (dim nmv)
  (let* ((sz  (expt dim 2))
	 (mvs (list #'left #'down #'right #'up))
	 (mlst '())
	 (p (make-puzzle :xpos (1- sz)
			 :mv root
			 :dim dim
			 :conf (make-array (list sz) :initial-element -1))))
    (loop for i from 0 to (- sz 2) 
	  do (setf (elt (puzzle-conf p) i) i))
    ;(print p)
    (decf sz)
    (random 4 (make-random-state t))
    (loop for i from 1 to nmv
	  do  (when (puzzle-p (funcall (elt mvs (random 4 (make-random-state t))) p))
		(push (puzzle-mv p) mlst)))
    (values (nreverse mlst) p)))

(defun puzzle-list (p)
  (let ((u (1- (expt (puzzle-dim p) 2)))
	(lst '()))
    (loop for i from u downto 0
	  do (push (elt (puzzle-conf p) i) lst))
    lst))

(defun puzzle-solvable (d n)
  (puzzle-list (nth-value 1 (puzzle-gen d n))))

(defun puzzle-dfs (p) 
  (puzzle-search #'(lambda (open sons) (append sons open)) #'straight-prune p))

(defun puzzle-bfs (p)
  (puzzle-search #'append #'straight-prune p))

(defun puzzle-parity (p) 
  (evenp 
    (+ (nth-value 0 (truncate (position -1 (puzzle-conf p)) (puzzle-dim p)))
       (apply #'+ (maplist #'(lambda (l) 
			       (count-if #'(lambda (x) 
					     (if (< x 0) 0
					       (>= (car l) x)))
					 (cdr l)))
			   (map 'list #'(lambda (x) x) (puzzle-conf p)))))))

(defmacro swap (p n0 n1)
  `(psetf (elt (puzzle-conf ,p) ,n0) (elt (puzzle-conf ,p) ,n1)
	 (elt (puzzle-conf ,p) ,n1) (elt (puzzle-conf ,p) ,n0)))

(defmacro xor (p0 p1)
  `(or (and ,p0 ,p1) (and (not ,p0) (not ,p1))))

(defun puzzle-gen+ (dim nmv)
  (let* ((sz  (expt dim 2))
	 (p (make-puzzle :xpos (1- sz)
			 :mv root
			 :dim dim
			 :conf (make-array (list sz) :initial-element -1)))
	 (parity t))
    (loop for i from 0 to (- sz 2) 
	  do (setf (elt (puzzle-conf p) i) i))
    (setf parity (puzzle-parity p))
    ;(print parity)
    ;(print p)
    (loop for i from 1 to nmv
	  do (let ((n0 (random sz))
		   (n1 (random sz)))
	       (swap p n0 n1)
	       ;(print (puzzle-parity p))
	       (when (xor parity (puzzle-parity p))
		 (swap p n0 n1))
	       ))
    p))




; finish puzzle with struct
; puzzle with class
; puzzle with list (square struct)

