(load "state")

(defclass jugs-state (state)
  ())


(defun jugs-conf (jA jB)
  (cons jA jB))

(defmethod world->state (jugs)
  (make-instance 'jugs-state 
		 :configuration (jugs-conf (car jugs) (cadr jugs))))

(defun jug-A (jst)
  (car (config jst)))

(defun jug-B (jst)
  (cdr (config jst)))

(defun fill-A (max-A)
  #'(lambda (state)
      (make-instance 'jugs-state 
		     :configuration (jugs-conf max-A (jug-B state))
		     :parent state
		     :transition 'fillA)))

(defun fill-B (max-B)
  #'(lambda (state)
      (make-instance 'jugs-state 
		     :configuration (jugs-conf (jug-A state) max-B)
		     :parent state
		     :transition 'fillB)))

(defun empty-A (state)
  (make-instance 'jugs-state 
		 :configuration (jugs-conf 0 (jug-B state))
		 :parent state
		 :transition 'emptyA))

(defun empty-B (state)
  (make-instance 'jugs-state 
		 :configuration (jugs-conf (jug-A state) 0)
		 :parent state
		 :transition 'emptyB))

(defun A-to-B (max-B)
  #'(lambda(state)
      (make-instance 'jugs-state
		     :configuration (if (<= (+ (jug-A state) (jug-B state)) 
					    max-B)
				      (jugs-conf 0 (+ (jug-A state) 
						      (jug-B state)))
				      (jugs-conf (- (jug-A state)
						    (- max-B (jug-B state)))
						 max-B))
				:parent state
				:transition 'A-to-B)))

(defun B-to-A (max-A)
  #'(lambda (state)
      (make-instance 'jugs-state
		     :configuration 
		     (if (<= (+ (jug-A state) (jug-B state)) max-A)
		       (jugs-conf (+ (jug-A state) (jug-B state)) 0)
		       (jugs-conf max-A (- (jug-B state)
					   (- max-A (jug-A state)))))
		     :parent state
		     :transition 'B-to-A)))

(defmethod equal? ((st0 jugs-state) (st1 jugs-state))
  (equalp (config st0) (config st1)))

(defmethod solution ((jst jugs-state))
  (print 'solution-found)
  (let
	((mvs '())
	 (pst jst))
	(loop
	  (when  (null (parent pst)) 
		(return (push (list 'initial (config pst)) mvs)))
	  (push (list (transition pst) (config pst)) mvs)
	  (setf pst (parent pst)))))

	  

(defclass jugs-problem (state-problem)
  ((max-A :initform 3
	  :initarg :max-A
	  :accessor max-A)
   (max-B :initform 4
	  :initarg :max-B
	  :accessor max-B)
   (final-A :initform 0
	    :initarg :final-A
	    :accessor final-A)
   (final-B :initform 4
	    :initarg :final-B
	    :accessor final-B)))

(defmethod branch ((jp jugs-problem))
  (let ((fst (car (open-set jp)))
		(max-A (max-A jp))
		(max-B (max-B jp)))
	(mapcar #'(lambda(op) (funcall op fst))
			(list (fill-A max-A) 
				  (fill-B max-B) 
				  #'empty-A 
				  #'empty-B 
				  (A-to-B max-B)
				  (B-to-A max-A)))))


(defmethod final? ((problem jugs-problem))
  (let ((jst (car (open-set problem))))
	(and (= (final-A problem) (jug-A jst)) 
		 (= (final-B problem) (jug-B jst)))))


(defun jugs-search (jA jB final-a final-b max-a max-b insert)
  (problem-search (make-instance 'jugs-problem
								 :open-set (list (world->state (list jA jB)))
								 :max-A max-a
								 :max-B max-b
								 :final-A final-a
								 :final-B final-b)
				  insert))

(defmethod solution ((jp jugs-problem))
  (solution (car (open-set jp))))

(defun repeat? (st)
  (let ((parst (parent st)))
	(loop
	  (when (null parst) 
		(return nil))
	  (when (equal? st parst) 
		(return t))
	  (setf parst (parent parst)))))

(defmethod prune ((jp jugs-problem) stlst)
  (remove-if #'(lambda (st) (repeat? st)) stlst))


